BEM.DOM.decl('schema-tree', {

    onSetMod : {

        'js' : function() {

            var schemaPage = this.findBlockOutside('schema-page'),
                searchInput = schemaPage.getSearchInput(),
                searchMatrix = schemaPage.getParams().searchIndex,
                matrixLen = searchMatrix.length - 1,
                _this = this;

            this._roots = this.elem('root');
            this._keys = this.elem('key');

            this._statusMap = [];
            this._searcheMap = [];

            for (var x = matrixLen; x >= 0; x--) {
                for (var y = searchMatrix[x].length - 1; y >= 0; y--) {
                    var item = searchMatrix[x][y];

                    !this._statusMap[x] && (this._statusMap[x] = []);
                    this._statusMap[x][y] = {
                        visible: -1,
                        mapIndex: this._searcheMap.length
                    };

                    item.self = { lvl: x, index: y };
                    item.searchTitle = item.title.toLowerCase();
                    item.searchInfo = item.info.toLowerCase();
                    item.domElem = $(this._roots[item.root]);
                    item.keyDomElem = this.findElem(item.domElem, 'key')[0];
                    item.descriptionDomElem = item.info && this.findElem(item.domElem, 'description')[0];

                    this._searcheMap.push(item);
                }
            }

            searchInput.on('change', function(){
                _this.beforeSearch(this.val());
            });

        }
    },

    chunkSize: 20,

    chunkTimeout: 1,

    beforeSearch: function(value) {
        if (this._searchValue != value) {
            this.stopSearch();
            this._searchValue = value.toLowerCase();
            this._regexp = new RegExp('(' + value.replace(/(.)/g, '[$1]') + ')', 'i');
            this.search(0);
        }
    },

    stopSearch: function() {
        this.reset();
        if (this._searchTimer) {
            clearTimeout(this._searchTimer);
            this._searchTimer = false;
        }
    },


    search: function(iteration) {
        var _this = this,
            filtered = 0;

        while (iteration < this._searcheMap.length - 1) {
            if (filtered == this.chunkSize) {
                this._searchTimer = setTimeout(function() {
                    _this.search(iteration)
                }, this.chunkTimeout);

                return;
            }

            var item = this._searcheMap[iteration],
                matchTitle = this.match(item.searchTitle),
                matchInfo = this.match(item.searchInfo),
                lvlSelf = item.self.lvl,
                indexSelf = item.self.index,
                parent = item.parent;

            if (~matchTitle || ~matchInfo) {
                ~matchTitle && this.highlight(item.keyDomElem, item.title);
                ~matchInfo && this.highlight(item.descriptionDomElem, item.info);

                this.setVisible(lvlSelf, indexSelf, 1)
                    .visibleBranch(parent.lvl, parent.index);
            } else {
                !~this.getVisible(lvlSelf, indexSelf) && this.setVisible(lvlSelf, indexSelf, 0);
            }

            iteration++;
            filtered++;
        }

        this.hideRoot();
    },

    setVisible: function(lvl, index, value) {
        this._statusMap[lvl][index].visible = value;

        return this;
    },

    hideRoot: function() {
        for (var x = 1; x < this._statusMap.length; x++) {
            for (var y = 0; y < this._statusMap[x].length; y++) {
                var statusItem = this._statusMap[x][y],
                    mapItem = this._searcheMap[statusItem.mapIndex],
                    isHidden = this.hasMod(mapItem.domElem, 'hidden', 'yes');

                if (!statusItem.visible && this.getVisible(mapItem.parent.lvl, mapItem.parent.index) == 1) {
                    this.setMod(mapItem.domElem, 'hidden', 'yes');
                } else {
                    isHidden && this.delMod(mapItem.domElem, 'hidden');
                }
            }
        }
    },

    highlight: function(domElem, orignal) {
        domElem.innerHTML = orignal.replace(this._regexp, function(str) {
            return '<span class="schema-tree__hlted">' + str + '</span>';
        });
    },

    getVisible: function(lvl, index) {
        return this._statusMap[lvl][index].visible;
    },

    visibleBranch: function(lvl, index) {
        if (lvl < 0 || this.getVisible(lvl, index) == 1) return;

        var item = this._searcheMap[this._statusMap[lvl][index].mapIndex];

        this.setVisible(lvl, index, 1)
            .visibleBranch(item.parent.lvl, item.parent.index);
    },

    match: function(string) {
        return this._searchValue == '' || string.indexOf(this._searchValue);
    },

    reset: function() {
        for (var x = 1; x < this._statusMap.length; x++) {
            for (var y = 0; y < this._statusMap[x].length; y++) {
                var statusItem = this._statusMap[x][y];

                if (statusItem.visible == 1) {
                    var item = this._searcheMap[statusItem.mapIndex],
                        keyDomElem = item.keyDomElem,
                        descriptionDomElem = item.info && item.descriptionDomElem;

                    keyDomElem.innerHTML != item.title && (keyDomElem.innerHTML = item.title);
                    descriptionDomElem && descriptionDomElem.innerHTML != item.info &&
                        (descriptionDomElem.innerHTML = item.info);
                }
                statusItem.visible = -1;
            }
        }
    }

}, {

    live: function() {
        this.liveBindTo({ modName: 'parent', modVal: 'yes', elemName: 'key' }, 'click', function(e) {
            var domElem = e.data.domElem,
                rootDomElem =  this._roots.eq(this._keys.index(domElem)),
                child = rootDomElem.children('.schema-tree__root'),
                hasAnyHidden = false,
                _this = this;

            for (var index = 0; index < child.length; index++) {
                hasAnyHidden = this.hasMod(child.eq(index), 'hidden', 'yes');

                if (hasAnyHidden) break;
            }

            function doSetTimeout(index) {
              setTimeout(function() {
                  if(!child[index]) return;

                  _this.setMod(child.eq(index), 'hidden', hasAnyHidden ? '' : 'yes');
                  doSetTimeout(index + 1);
              }, 0);
            }

            doSetTimeout(0);
//            for (var index = 0; index < child.length; index++) {
//                child.eq(index)[hasAnyHidden ? 'slideDown' : 'slideUp']('fast');
//                this.setMod(child.eq(index), 'hidden', hasAnyHidden ? '' : 'yes');
//            }
        });
        return false;
    }

});
