var levels = require('enb-bem-techs/techs/levels'),
    deps = require('enb-bem-techs/techs/deps'),
    files = require('enb-bem-techs/techs/files'),
    fileProvider = require('enb/techs/file-provider'),
    js = require('enb/techs/js'),
    css = require('enb/techs/css'),
    borschik = require('enb-borschik/techs/borschik'),
    inlineCss = require('./enb-techs/inline-css'),
    prependVersion = require('./enb-techs/prepend-version');

module.exports = function(config) {

    config.node('tableau/desktop', buildLevels(['common', 'deskpad', 'desktop']));
    config.node('tableau/touch-pad', buildLevels(['common', 'deskpad', 'touch', 'touch-pad']));
    config.node('tableau/touch-phone', buildLevels(['common', 'touch', 'touch-phone']));
    config.node('tableau/all', buildLevels(['common', 'deskpad', 'desktop', 'touch', 'touch-pad', 'touch-phone']));

    function buildLevels(levelNames) {
        return function(nodeConfig) {
            nodeConfig.addTechs([
                [levels, {levels: getLevels()}],
                [fileProvider, {target: '../tableau.bemdecl.js'}],
                [deps, {bemdeclFile: '../tableau.bemdecl.js'}],
                files,
                js,
                css,
                inlineCss,
                [borschik, {sourceTarget: '?.all.js', destTarget: '?.min.js', minify: true, freeze: false}],
                [prependVersion, {sourceTarget: '?.all.js', target: '_?.js'}],
                [prependVersion, {sourceTarget: '?.min.js', target: '_?.min.js'}]
            ]);

            nodeConfig.addTargets(['_?.js', '_?.min.js']);

            function getLevels() {
                return levelNames.map(function(level) {
                    return config.resolvePath({path: level + '.blocks', check: true});
                });
            }
        };
    }
};
