var cssmin = require('cssmin/cssmin');

module.exports = require('enb/lib/build-flow').create()
    .name('inline-css')
    .target('target', '?.all.js')
    .useSourceText('jsSource', '?.js')
    .useSourceText('cssSource', '?.css')
    .defineOption('pattern', '/*{STYLE}*/\'\'')
    .builder(function(jsSource, cssSource) {
        return jsSource.replace(this._pattern, '\'' + cssmin(cssSource).replace(/'/g, '\\\'') + '\'');
    })
    .createTech();
