#!/usr/bin/env bash

set +vx

SCRIPT_DIR=$(cd $(dirname $0); pwd)
BIN_DIR="${SCRIPT_DIR}/node_modules/.bin"
CSSCOMB="${BIN_DIR}/csscomb"
AP="${BIN_DIR}/autoprefixer"

# Если установлена переменная окружения verbose, в консоль будет выведена
# подробная информация о конфигурации autoprefixer.
#
# Использовать как verbose=1 ./autoprefix
if [ -z "${verbose}" ]; then
   verbose="false"
fi

# Запускает autoprefixer в режиме info.
# $1 передаётся в качестве значения опции --browsers.
#
# Пример: apInfo "...browsers..."
function apInfo() {
    if [ "${verbose}" == "true" ]; then
        ${AP} --browsers "$1" --info
    else
        echo "-- $1"
    fi
}

# Запускает autoprefixer через xargs.
# $1 передаётся в качестве значения опции --browsers.
#
# Пример: find ... | ap "...browsers..."
function ap() {
    xargs ${AP} --browsers "$1" --cascade
}

# В common.blocks лежит общий для всех платформ код.
#
# 1.1. Код в *.css должен работать во
# - всех поддерживаемых touch-браузерах
# - всех поддерживаемых десктопных браузерах (включая поддерживаемые версии IE)
#
# 1.2. *.ie*.css файлов быть не должно.
echo "== *.blocks/**/*.css"
BRO="last 2 versions, opera >= 12.1, ff >= 23, android >= 2.3, ios >= 5.1, ie >= 8"
apInfo "${BRO}"
find *.blocks -name "*.css" | grep -v ".ie" | ap "${BRO}"
