(function($, Tableau) {

var DESKPAD_OFFSET_TOP = -2;
var DESKPAD_OFFSET_SIDE = 20;

Tableau._onDevice(['desktop', 'touch-pad'], {
    _reposition: function(__base) {

        console.log('reposition');
        var params = this._params,
            $header = params.headerElem;

        if($header) {
            var $trigger = params.triggerElem,
                $tableau = this._$tableau,

                triggerOffset = $trigger.offset(),
                triggerWidth = $trigger.outerWidth(),
                tableauWidth = $tableau.outerWidth();

            if(this._params.device === 'desktop') { // left alignment
                this._left = Math.max(DESKPAD_OFFSET_SIDE, triggerOffset.left + triggerWidth - tableauWidth);
            } else { // right alignment
                this._left = Math.min($(window).width() - tableauWidth - DESKPAD_OFFSET_SIDE, triggerOffset.left);
            }

            var tableauTop = $header.offset().top + $header.outerHeight() + DESKPAD_OFFSET_TOP,
                tailLeft = triggerOffset.left - this._left + (triggerWidth - this._$tail.outerWidth()) / 2;

            this._top = Math.round(tableauTop);
            this._tail = Math.round(tailLeft);

        }
        __base();
    }
});

})(jQuery, jQuery.Tableau);
