(function($, Tableau) {

var TOGGLE_DELAY = 300;

Tableau._onDevice('desktop', {
    _bindWiringHandlers: function(__base) {
        __base();
        this._toggleTimer = null;
        this._mousePressed = false;
        var $trigger = this._params.triggerElem,
            $body = $(document.body);
        this._bindHandler($trigger, 'mousemove', onMouseMove)
            ._bindHandler($trigger, 'mouseleave', onMouseLeave)
            ._bindHandler($body, 'mousedown', onMouseDown)
            ._bindHandler($body, 'mouseup dragend', onMouseUp)
            ._bindHandler(this._$tableau, 'mouseenter mousemove', onMouseMove)
            ._bindHandler(this._$tableau, 'mouseleave', onMouseLeave);
    }
});

Tableau.prototype._clearToggleTimer = function() {
    if(this._toggleTimer) {
        clearTimeout(this._toggleTimer);
        this._toggleTimer = null;
        return true;
    }
    return false;
};

function onMouseMove() {
    var _this = this;
    this._clearToggleTimer();
    if(this.isOpened() || this._mousePressed) { return }
    this._toggleTimer = setTimeout(function() {
        _this.open();
        _this._toggleTimer = null;
    }, TOGGLE_DELAY);
}

function onMouseLeave(e) {
    var _this = this;
    // FF иногда бросает mouseleave при неподвижном курсоре в процессе анимации открытия табло
    // Если мышь в этот момент находится внутри лого, не нужно закрывать табло
    if(this._clearToggleTimer() || isInside(e, this._params.triggerElem)) { return }
    this._toggleTimer = setTimeout(function() {
        _this.close();
        _this._toggleTimer = null;
    }, TOGGLE_DELAY);
}

function isInside(e, $elem) {
    var offset = $elem.offset();
    return e.clientX > 0 && e.clientY > 0 &&
        e.pageX < $elem.outerWidth() + offset.left && e.pageY < $elem.outerHeight() + offset.top;
}

function onMouseDown() {
    if(!this.isOpened()) {
        this._clearToggleTimer();
    }
    this._mousePressed = true;
}

function onMouseUp() {
    this._mousePressed = false;
}

})(jQuery, jQuery.Tableau);
