(function($, Tableau) {

Tableau._onDevice(['touch-pad', 'touch-phone'], {
    _bindWiringHandlers: function(__base) {
        __base();
        this._bindHandler($(document.body), 'click', onClickOutside);
    }
});

function onClickOutside(e) {
    var target = e.target,
        tableau = this.getNode(),
        trigger = (this._params.triggerElem || [])[0];
    if(this.isOpened() && target !== tableau && !$.contains(tableau, target) &&
        trigger && target !== trigger && !$.contains(trigger, target)) {
        this.close();
    }
}

})(jQuery, jQuery.Tableau);
