block('b-mobile-app')(
    content()(function() {
        var lang = this.ctx.lang,
            OSFamily = this.ctx.OSFamily,
            withoutApp = OSFamily !== 'iOS' && OSFamily !== 'Android';

        return [
            {
                elem: 'title',
                content: iget2('b-mobile-app', 'title-who-already-in-direct', 'Приложение для тех,<br>кто уже в Директе')
            },
            {
                elem: 'description',
                content: iget2(
                    'b-mobile-app',
                    'description-who-already-in-direct',
                    'Приложение Яндекс.Директ позволит эффективно управлять рекламными кампаниями вдали от компьютера'
                )
            },
            (withoutApp || OSFamily === 'Android') && {
                elem: 'app',
                elemMods: { type: 'google-play' },
                content: {
                    block: 'b-mobile-badge',
                    mods: { type: 'google-play' },
                    url: 'https://play.google.com/store/apps/details?id=ru.yandex.direct&pcampaignid=MKT-Other-global-all-co-prtnr-py-PartBadge-Mar2515-1',
                    lang: lang
                }
            },
            (withoutApp || OSFamily === 'iOS') && {
                elem: 'app',
                elemMods: { type: 'app-store' },
                content: {
                    block: 'b-mobile-badge',
                    mods: { type: 'app-store' },
                    url: 'https://itunes.apple.com/ru/app/id583627331',
                    lang: lang
                }
            }
        ];
    })
);
