block('b-mobile-footer')(

    content()(function() {
        return {
            elem: 'wrap',
            content: [
                {
                    elem: 'links',
                    content: [
                        {
                            title: iget2('b-mobile-footer', 'direct-training', 'Обучение Директу'),
                            url: u.consts('lang') === 'ru' ?
                                '//www.youtube.com/playlist?list=PLjEKjSpX1kHXauwZzl6r4vxSJa85A5o58' :
                                '//www.youtube.com/playlist?list=PLjEKjSpX1kHVoSo5VTNTW4fl7Gzi0dcyX'
                        },
                        {
                            title: iget2('b-mobile-footer', 'adv-agency', 'Рекламные  агентства'),
                            mix: [
                                {
                                    block: 'b-metrika',
                                    js: {
                                        goal: 'menu_help_agency',
                                        counter: '34'
                                    }
                                },
                                {
                                    block: 'b-metrika',
                                    js: {
                                        goal: 'menu_help_agency',
                                        counter: '191494'
                                    }
                                }
                            ],
                            url: u.formatUrl({
                                protocol: 'https',
                                host: 'yandex.' + u.consts('tld'),
                                path: 'adv/contact/agency'
                            })
                        },
                        {
                            title: iget2('b-mobile-footer', 'adv-on-yandex', 'Реклама на Яндексе'),
                            url: u.formatUrl({
                                protocol: 'https',
                                host: 'yandex.' + u.consts('tld'),
                                path: 'adv'
                            })
                        },
                        {
                            title: iget2('b-mobile-footer', 'metrika-yandex', 'Яндекс.Метрика'),
                            url: u.formatUrl({
                                protocol: 'https',
                                host: 'metrika.yandex.' + u.consts('tld')
                            })
                        }
                    ].map(function(link) {
                        return {
                            block: 'link',
                            mods: { theme: 'black' },
                            mix: [
                                {
                                    block: 'b-mobile-footer',
                                    elem: 'link'
                                }
                            ].concat(link.mix || []),
                            url: link.url,
                            content: link.title
                        }
                    })
                },
                {
                    block: 'copyright',
                    mix: {
                        block: 'b-mobile-footer',
                        elem: 'copyright'
                    },
                    elemLinkMix: {
                        block: 'link',
                        mods: { theme: 'black' }
                    },
                    start: u.consts('domains').tr ? 2011 : 2001
                },
                {
                    block: 'lang-switcher',
                    mix: {
                        block: 'b-mobile-footer',
                        elem: 'lang-switcher'
                    },
                    noMore: true,
                    retPath: this.ctx.retPath || encodeURIComponent(u.getCurrentUrl(this.ctx.retPathParams))
                }
            ]
        };
    })

);
