block('b-morda-hero').elem('widget').content()(function() {
    var support = this.ctx.support;

    return {
        elem: 'content',
        content: [
            {
                elem: 'title',
                tag: 'h1',
                content: iget2('b-morda-hero', 'novye-klienty-br-dlya', 'Новые клиенты <br> для вашего бизнеса')
            },
            {
                elem: 'text',
                tag: 'p',
                content: iget2(
                    'b-morda-hero',
                    'text-touch',
                    'Контекстные объявления и медийные<br>баннеры — на десктопах и в мобильных.<br>Реклама на поиске Яндекса и на тысячах<br>площадок рекламных сетей.'
                )
            },
            {
                elem: 'new-camp',
                elemMods: {
                    theme: 'action',
                    size: 'promo-l'
                },
                url: this.ctx.links.newCamp,
                text: iget2('b-morda-hero', 'zapustit-reklamu', 'Запустить рекламу')
            },
            support.phone && {
                elem: 'note',
                content: [
                    iget2('b-morda-hero', 'ili-obratites-za-konsultaciey-184', 'или обратитесь за консультацией<br>к специалисту Яндекса по тел.') + ': ',
                    {
                        elem: 'note-tel',
                        mix: [
                            {
                                block: 'b-morda-hero',
                                elem: 'button'
                            },
                            {
                                block: 'b-metrika',
                                js: {
                                    goal: 'MOBILE-PHONE',
                                    counter: '34'
                                }
                            },
                            {
                                block: 'b-metrika',
                                js: {
                                    goal: 'MOBILE-PHONE',
                                    counter: '191494'
                                }
                            }
                        ],
                        tag: 'a',
                        attrs: {
                            href: 'tel:' + support.phone
                        },
                        content: [
                            support.phone,
                            support.add &&
                                (', ' +
                                    iget2('b-morda-hero', 'dob-additionalphonenumber', 'доб.&nbsp;{additionalPhoneNumber}', {
                                        additionalPhoneNumber: function() {
                                            return support.add;
                                        }()
                                    })
                                )
                        ]
                    },
                    support.supportComment &&
                        support.supportComment.substring(0, 1).toUpperCase() + support.supportComment.substring(1)
                ]
            }
        ]
    };
});
