block('b-news')(

    content()(function() {
        var theme = (this.ctx.mods || {}).theme;

        return [
            {
                elem: 'title',
                tag: 'h2',
                content: [
                    iget2('b-news', 'novosti', 'Новости')
                ]
            },
            {
                elem: 'list',
                tag: 'ul',
                content: this.ctx.news.map(function(news) {

                    return {
                        elem: 'item',
                        tag: 'li',
                        content: [
                            {
                                elem: 'item-text',
                                theme: theme,
                                content: news.content
                            },
                            {
                                elem: 'item-date',
                                content: news.date
                            }
                        ]
                    };
                })
            },
            {
                elem: 'archive',
                theme: theme,
                url: this.ctx.links.archive,
                text: iget2('b-news', 'all-news', 'Все новости')
            }
        ];
    })
);
