BEM.DOM.decl({ block: 'email-collector' }, {

    onSetMod: {

        js: function() {
            this._input = this.blockInside('input');
        },

        error: {
            yes: function() {
                this._input.setMod(this._input.elem('message'), 'visibility', 'visible');
            },
            '': function() {
                this._input.delMod(this._input.elem('message'), 'visibility');
            }
        },

        progress: {
            yes: function() {
                this.blockInside('button', 'button2').setMod('progress', 'yes');
            },
            '': function() {
                this.blockInside('button', 'button2').delMod('progress');
            }
        }
    },

    /**
     * Возвращает значение поля
     * @returns {String}
     */
    getValue: function() {
        return this._input.val();
    },

    /**
     * Валидирует эл.адрес
     * @param {String} email - адрес
     * @returns {boolean}
     * @private
     */
    _validate: function(email) {
        return u.emailRegExp().test(email);
    },

    /**
     * Обработчик отправки значения на сервер
     * @private
     */
    _onEmailSendRequest: function() {
        var email = this._input.val();

        if (email.length === 0) {
            this.showError(iget2('email-collector', 'value-empty', 'Введите адрес эл.почты'));
        } else if (!this._validate(email)) {
            this.showError(iget2('email-collector', 'value-invalid', 'Неправильный формат'));
        } else {
            this._sendEmail(email)
                .then(this._onSuccess.bind(this))
                .catch(this._onError.bind(this));
        }
    },

    /**
     * Отправка значения на сервер
     * @param {String} email
     * @private
     */
    _sendEmail: function(email) {

        return new Promise(function(resolve, reject) {
            this.setMod('progress', 'yes');
            setTimeout(function() {    // TODO @grimfrid тут ждем бекенд
                resolve()
            }, 2000)
        }.bind(this));
    },

    /**
     * Обработчик успешной отправки
     * @param {Object} response
     * @private
     */
    _onSuccess: function(response) {
        this.delMod('progress');
        this._input.clearInput();
        this.trigger('success', { response: response });
    },

    /**
     * Обработчик неудачной отправки
     * @param {Object} response
     * @private
     */
    _onError: function(response) {
        this.delMod('progress');
        this.trigger('error', { response: response });
    },

    /**
     * Показывает ошибку под полем ввода
     * @param {String} text - текст ошибки
     * @private
     */
    showError: function(text) {
        BEM.DOM.update(this._input.elem('message'), text);
        this.setMod('error', 'yes');
    },

    /**
     * Обработчик нажатия на кнопку "Отправить"
     * @private
     */
    _onButtonClick: function() {
        this.delMod('error');
        this._onEmailSendRequest();
    },

    /**
     * Обработчик фокуса ни поле ввода
     * @private
     */
    _onInputFocus: function() {
        this.delMod('error');
    },

    /**
     * Обработчик нажатий клавиш в инпуте
     * @param {Event} e
     * @private
     */
    _handleKeypress: function(e) {
        if (e.which === BEM.blocks.keycodes.ENTER) {
            this._onEmailSendRequest();
        }
    }

}, {
    live: function() {
        this
            .liveInitOnBlockInsideEvent('click', 'button2', function(e) {
                this._onButtonClick(e);
            })
            .liveInitOnBlockInsideEvent('focus', 'input', function(e) {
                this._onInputFocus(e);
            })
            .liveBindTo('input', 'keypress', function(e) {
                this._handleKeypress(e);
            });
    }
});
