block('header2').mod('type', 'direct').match(function() {
    return this.data.cmd !== 'proveNewAgencyClients';
})(

    mode('left')(function() {
        return [{
            elem: 'service',
            name: this['i-global']['id'],
            lang: /en|tr/.test(u.consts('lang')) ? 'en' : 'ru',
            alt: iget2('header2', 'direkt', 'Директ'),
            url: '/'
        }];
    }),

    mode('right')(

        match(function() {
            return this['i-global'].login;
        })(function() {
            var data = this.data,
                global = this['i-global'];

            return [{
                elem: 'direct',
                content: [
                    {
                        block: 'user2',
                        uid: global.UID,
                        yu: global.yandexuid,
                        name: global.login,
                        retpath: global.retpath,
                        passportHost: global['passport-host'],
                        avatarId: data.display_name ? data.display_name.avatar['default'].content : null,
                        origin: 'direct',
                        mods: {
                            'fetch-accounts': 'yes',
                            'with-pin-code': 'yes'
                        },
                        js: {
                            accountsMax: 100
                        },
                        mix: [{
                            block: 'header2',
                            elem: 'user'
                        }]
                    }
                ]
            }];
        }),

        match(function() {
            return !this['i-global'].login;
        })(function() {
            var title = iget2('header2', 'voyti', 'Войти');

            return {
                block: 'button',
                mods: { size: 'm', theme: 'pseudo' },
                mix: { block: 'header2', elem: 'enter' },
                attrs: {
                    tabindex: '-1',
                    title: title
                },
                url: u.formatUrl({
                    protocol: this.data.SCRIPT_OBJECT.protocol,
                    host: this.data.passport_domain,
                    path: '/auth',
                    query: {
                        origin: 'direct',
                        retpath: this.data.index_page ? this.data.cur_page : u.getCurrentUrl()
                    }
                }, true),
                content: [
                    {
                        block: 'image',
                        mix: {
                            block: 'button',
                            elem: 'icon',
                            elemMods: { 16: 'enter' }
                        },
                        alt: ''
                    },
                    {
                        block: 'header2',
                        elem: 'enter-label',
                        content: title
                    }
                ]
            };
        })
    )

);
