BEM.DOM.decl({ block: 'launch-advertising', implements: 'i-modal-popup-inner-block-interface' }, {

    onSetMod: {
        js: function() {
            this._emailCollector = this.blockInside('email-collector');
        }
    },

    /**
     * Проверяет были ли изменения в блоке, которые нужно сохранить перед закрытие попапа
     * @return {*}
     */
    isChanged: function() {
        var deferred = $.Deferred();

        deferred.resolve(!u._.isEmpty(this._emailCollector.getValue()));

        return deferred;
    },

    /**
     * Обработчик успешного сохранения эл.почты
     */
    onEmailCollectSuccess: function() {
        this.setMod('state', 'desktop');
    },

    /**
     * Обработчик неудачного сохранения эл.почты
     */
    onEmailCollectError: function() {
        this.blockInside('email-collector').showError(
            iget2('launch-advertising', 'email-save-error', 'Не удалось сохранить. Попробуйте позднее')
        );
    }

}, {

    live: function() {

        this
            .liveInitOnBlockInsideEvent('success', 'email-collector', function() {
                this.onEmailCollectSuccess();
            })
            .liveInitOnBlockInsideEvent('error', 'email-collector', function() {
                this.onEmailCollectError();
            })

        return false;
    }

});
