block('p-morda').content()(function() {

    var DEFAULT_VARIANT = 2, // фото мужчины с дрелью (см. DIRECT-73438)
        variant = this.ctx.variant || DEFAULT_VARIANT, // DIRECT-60696 Эксперимент с мордами Директа
        links = this.ctx.links,
        support = this.ctx.support,
        videoSrc = this.ctx.videoSrc,
        stories = this.ctx.stories,
        news = this.ctx.news,
        geoRegion = this.ctx.geoRegion,
        showStatistics = this.ctx.showStatistics,
        res = [];

    // hero блок
    res.push({
        block: 'b-morda-hero',
        mods: { type: variant.toString() }, // DIRECT-60696 Эксперимент с мордами Директа
        mix: [
            { block: 'p-morda', elem: 'row' },
            { block: 'p-morda', elem: 'hero' }
        ],
        links: links,
        support: support
    });

    res.push({
        block: 'morda-features',
        mix: [
            { block: 'p-morda', elem: 'row' }
        ]
    });

    res.push({
        elem: 'news',
        mix: [
            { block: 'p-morda', elem: 'row' }
        ],
        content: u._.extend(news, { mods: { theme: 'black' } })
    });

    // видео
    videoSrc && res.push({
        elem: 'video',
        mix: [{ elem: 'row' }]
    });

    showStatistics && res.push({
        block: 'wordstat',
        geoRegion: geoRegion,
        mix: [
            { block: 'p-morda', elem: 'row' },
            { block: 'p-morda', elem: 'stat' }
        ]
    });

    // истории
    stories && stories.length && res.push({
        block: 'success-stories',
        mix: [{ block: this.block, elem: 'row' }],
        stories: stories
    });

    res.push({
        block: 'b-mobile-app',
        lang: u.consts('lang'),
        OSFamily: this.ctx.uatraits.OSFamily
    });

    return res;
});
