block('success-stories')(

    js()(true),

    elem('email-collect-success').content()(function() {
        return [
            {
                elem: 'email-collect-title',
                content: iget2(
                    'success-stories',
                    'email-collect-success-title',
                    'Спасибо!'
                )
            },
            {
                elem: 'email-collect-text',
                content: iget2(
                    'success-stories',
                    'email-collect-success-text',
                    'Ожидайте письмо.'
                )
            },
            {
                elem: 'email-collect-back',
                content: {
                    block: 'link',
                    mods: {
                        theme: 'normal'
                    },
                    content: iget2(
                        'success-stories',
                        'email-collect-success-link',
                        'Оставить другой адрес'
                    )
                }
            }
        ];
    }),

    elem('story').content()(function() {
        var story = this.ctx.story;

        return {
            block: 'link',
            mods: { theme: 'black' },
            mix: [
                {
                    block: this.block,
                    elem: 'story-wrap-link'
                },
                {
                    block: 'b-metrika',
                    js: {
                        goals: [{
                            goal: 'story_click',
                            counter: '191494'
                        },
                        {
                            goal: 'story_click',
                            counter: '34'
                        }]
                    }
                }
            ],
            url: story.url,
            content: {
                block: 'card',
                mods: {
                    lazyload: 'yes'
                },
                mix: { block: this.block, elem: 'card' },
                content: [
                    {
                        elem: 'image',
                        js: {
                            src: story.image
                        },
                        mix: {
                            block: this.block,
                            elem: 'user-image'
                        },
                        attrs: {
                            width: '102px',
                            height: '102px',
                            alt: story.company,
                            src: ''
                        }
                    },
                    {
                        elem: 'title',
                        content: story.company
                    },
                    {
                        elem: 'text',
                        content: '«' + story.quote + '»'
                    }
                ]
            }
        };
    }),

    content()(function() {
        var stories = this.ctx.stories

        return [
            {
                elem: 'header',
                content: {
                    elem: 'title',
                    content: iget2('success-stories', 'title', 'Истории успеха наших клиентов')
                }
            },
            {
                elem: 'wrapper',
                content: {
                    elem: 'slider',
                    tag: 'ul',
                    content: [
                        stories.map(function(story) {
                            return {
                                elem: 'slide',
                                tag: 'li',
                                content: {
                                    block: this.block,
                                    elem: 'story',
                                    story: story
                                }
                            }
                        })
                    ]
                }
            }
        ];
    })
)
