BEM.DOM.decl('success-stories', {

    onSetMod: {
        js: function() {
            this._cards = this.findBlocksInside('card');
            this._carousel = this.elem('slider');
            this._carousel.itemslide();
            this._carousel.on('changeActiveIndex', function(e) {
                this._lazyLoadCardImage(this._carousel.getActiveIndex());
            }.bind(this));

            this._lazyLoadCardImage(0);

        }
    },

    /**
     * Загружает картинки для следующих 4 слайдов
     * @param {Number} index - номер текущего слайда
     * @private
     */
    _lazyLoadCardImage: function(index) {
        var start = index,
            end = this._cards.length - index > 4 ? index + 4 : this._cards.length;

        for (var i = start; i < end; i++) {
            this._cards[i].loadImage();
        }

    }

});
