var fs = require('fs'),
    path = require('path'),
    vm = require('vm'),
    util = require('util'),
    root = path.join(__dirname, '../desktop.blocks'),
    rootBlock = process.argv[2],
    Vow = require('vow'),
    vowFs = require('vow-fs');

function inspect(data) {
    console.log(util.inspect(data, false, null));
}

function cloneOf(obj) {
    return util._extend({}, obj);
}

function asArray(entity) {
    return entity instanceof Array ? entity : [entity];
}

function blockPath(block) {
    return path.join(root, block);
}

function getBlocksByDeps(block) {
    var depsPath = path.join(blockPath(block), '**/*deps.js');

    return vowFs.glob(depsPath).then(function(depsFiles) {
        var blocks = {};

        depsFiles.forEach(function(filePath) {
            var file = fs.readFileSync(filePath),
                deps = vm.runInThisContext(file);

            deps = asArray(deps);
            deps.forEach(function(tech) {
                ['mustDeps', 'shouldDeps'].forEach(function(key) {
                    if (tech[key]) {
                        tech[key] = asArray(tech[key]);
                        tech[key].forEach(function(decl) {
                            if (decl.block)
                                blocks[decl.block] = true;
                        });
                    }
                });
            });
        });

        return blocks;
    });
}

var blocks = {},
    blocksPrev = {};

blocks[rootBlock] = true;

var doWork = function() {
    blocksPrev = cloneOf(blocks);
    
    return Vow.all(Object.keys(blocks).map(function(block) {
        return getBlocksByDeps(block).then(function(blockDeps) {
            util._extend(blocks, blockDeps);
        });
    })).then(function() {
        if (Object.keys(blocks).length != Object.keys(blocksPrev).length) {
            return doWork();
        } else {
            return blocks;
        }
    });
}

doWork()
    .then(function(blocks) {
        Object.keys(blocks).forEach(function(block) {
            console.log(block);
        });
    })
    .fail(console.log.bind(console));

