#!/usr/bin/env node

console.log('Проверка на наличие подстроки "BEMHTML.apply" в utils.js файлах', '\n');

var cmdline = 'grep \'BEMHTML.apply\' -r -n --include \\*.utils.js -B1 desktop.blocks/ || true';

require('child_process').exec(cmdline, function (error, stdout, stderr) {

    if (error) {
        console.error(error);
        process.exit(1);
    }

    var lines = stdout.split('\n'),
        rex = /ignore\s+bemhtml/i,
        result = 0;

    for (var i = 0, l = lines.length; i < l; i++) {

        var line = lines[i],
            lineBefore = lines[i - 1] || '';

        if (/^\-\-/.test(line)) continue;

        if (/BEMHTML\.apply/.test(line) && !rex.test(line) && !rex.test(lineBefore)) {
            var lineArr = line.split('BEMHTML.apply');

            console.log(lineArr.join('\x1B[31mBEMHTML.apply\x1B[39m'));
            result = 1;
        }

    }

    if (result) console.log('Найдены использования BEMHTML.apply, для игнора добавте коментарий "ignore bemhtml" в той же строке или до нее');
    process.exit(result);
});
