#!/bin/bash
# Проверка наличия изменений версии bricks в транке с момента последнего мержа транка или создания ветки

DT=svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/direct/perl
DB=svn+ssh://arcadia.yandex.ru/arc/branches/direct/perl
WC_URL=$(svn info --xml|grep -oP '(?<=<url>).*(?=</url>)')
BRANCH_NAME=$(echo $WC_URL| grep -oP '(?<=branches/direct/perl/).*?(?=/)')
IS_TRUNK=$(echo $WC_URL | grep "trunk/arcadia/direct/perl")

# если url рабочей копии - не транк, значит ветка
if [ -z "$IS_TRUNK" ]; then
    # до какой ревизии в ветку вмержен транк
    TRUNK_MERGE_REV=$(svn mergeinfo --show-revs merged $DT $DB/$BRANCH_NAME | tail -n 1)
    # если транк еще не мержился, то последняя ревизия транка - ревизия создания ветки
    BRANCH_CREATE_REV=$(svn log -r 1:HEAD --limit 1 --stop-on-copy | grep -oP "(?<=r)\d+")

    if [[ $TRUNK_MERGE_REV ]]; then
        REV=$TRUNK_MERGE_REV
    else
        REV=$BRANCH_CREATE_REV
    fi

    # смотрим, менялся ли bricks в транке от последней вмерженной в ветку ревизии до текущего момента
    DIFF=$(svn diff ^/trunk/arcadia/direct/perl/data3/package.json -r $REV:HEAD | grep bricks)

    if [[ $DIFF ]]; then
        echo "От времени последнего мержа транка в ветку в транке изменилась версия bricks:"
        echo "$DIFF"
        exit 1
    else
        echo "Версия bricks в ветке актуальна"
    fi
fi
