#!/bin/bash

bundleFolder=$1
bundleFolderPath="$PWD/$bundleFolder"
expectedBundleFiles="$PWD/$bundleFolder/expectedBundleFiles.txt";

echo "Checking folder '$bundleFolder' for bundle files."

DIRECT_BUNDLE_DECL=desktop.bundles/direct/direct.bemdecl.js

if [[ ! -f "$DIRECT_BUNDLE_DECL" ]];
then
    echo "Script must be executed from the 'data3' folder"
    exit 1
fi

if [[ -z $bundleFolder ]]
then
    echo "There is no '$bundleFolder' folder containing the file with a list of bundle files."
    exit 1
fi

if [[ ! -f $expectedBundleFiles ]]
then
    echo "File '$expectedBundleFiles' does not exist."
    exit 1
fi


isSuccess=true

while read LINE
do
    if [[ ! -f "$bundleFolderPath/$LINE" ]]
    then
        echo "File '$LINE' does not exist"
        isSuccess=false
    fi
done < $expectedBundleFiles


if [[ $isSuccess = true ]]
then
    echo 'Bundle files check completed successfully.'
    exit 0
else
    echo 'An error occurred while checking bundle files.'
    exit 1
fi
