#!/usr/bin/env node
/**
 * Скрипт проверки использования перловых функций
 * Игнорирует строки, помеченные check-functions:ignore
 */

console.log('Проверка использования перловых функций');
var colorize = require('chalk').red,
    fnList = [
        'base_media_format',
        'can_disable',
        // 'is_page_disabled',
        'ceil',
        'console_log',
        'conv_unit_explanation',
        'dumper',
        'floor',
        'format_const',
        'format_currency',
        'format_date',
        'format_file_size',
        'format_href',
        'format_int',
        'format_price',
        'format_sum_of_money',
        'format_units',
        'get_currency_constant',
        'get_currency_text',
        'get_current_url_params',
        'get_doc_path',
        'get_file_content',
        'get_geo_names',
        'get_plot_link',
        'get_ref',
        'get_sort_table_header',
        'get_svn_info',
        'get_url',
        'get_word_for_digit',
        'html_escape',
        'iget',
        'iget_noop',
        'is_page_disabled',
        'is_targeting_in_region',
        'js_encode',
        'json_dump',
        'media_format_by_id',
        'log_schema_validate_errors',
        'phrase_text2detail_hash',
        'piget',
        'piget_array',
        'rbac_role_name',
        //'read_schema_bundle',
        'round2s',
        'sort_table_data',
        'string2html',
        'trim_float',
        'truncate',
        'uri_escape',
        'warn'
    ],
    joined = '(' + fnList.join('|') + ')',
    regex = 'data\\.' + joined + '\\(',
    cmdline = 'grep -E \'' + regex +'\' -r -n --include \\*.bemtree.js --include \\*.bemhtml.js --include \\*.utils.js desktop.blocks common.blocks| grep -v "check-functions:ignore"';

require('child_process').exec(cmdline, function(error, stdout, stderr) {

    if (error && error.code != 1) {
        console.error(error);
        process.exit(1);
    }

    var lines = stdout.split('\n').filter(function(line) { return !!line; }),
        fnRegex = new RegExp(joined),
        result = lines.length,
        list = {};

    lines
        .forEach(function(line) {
            list[line.match(fnRegex)[0]] = true;
            console.log(line.replace(/\s+/, ' ').replace(fnRegex, colorize('$&')));
        });

    if (result) console.log(colorize('\nНайдено использование перловых функций\n') + Object.keys(list).join('\n'));
    process.exit(result);
});
