#!/usr/bin/env node

/**
 * Скрипт проверки корректного использования параметров i-global
 */

console.log('Проверка параметров i-global');

var exec = require('child_process').exec,
    vow = require('vow'),
// Разрешенные параметры
    legoConsts = [
    'id',
    'legoVersion',
    'staticVersion',
    'legoHost',
    'staticHost',
    'social_host',
    'secret-key',
    'retpath',
    'social_retpath',
    'passport-msg',
    'yandexuid',
    'login',
    'raw_login',  // пришлось добавить, т.к. в переменную login по факту приходит фамилия
    'oframebust',
    'passport-host',
    'pass-host',
    'yandex_domain',
    'isClientOfDirect',
    'tld',
    'locale',
    'content-region',
    'user-region',
    'lang',
    // не лего, но разрешена из-за частого использования
    'csrf_token',
    'nonce'
];

vow
    .all([
        processByLine(
            // #cyn@TODO: DIRECT-53578: заменить расширения файлов bemhtml -> bemhtml.js и разобраться с ошибками
            'grep "this\\[\'i\\-global\'\\]" -r -n --include \\*.bemtree.js --include \\*.bemhtml *.blocks/',
            function(line) {
                var param1 = line.match(/this\['i\-global']\.([a-zA-Z_]+)/),
                    param2 = line.match(/this\['i\-global']\['([a-zA-Z_-]+)']/);

                return param1 && param1[1] || param2 && param2[1];
            }),
        processByLine(
            'grep "BEM\\.blocks\\[\'i\\-global\']\\.param" -r -n --include \\*.js --exclude \\*.test.js --exclude i-utils__consts.utils.js *.blocks/',
            function(line) {
                var param = line.match(/BEM\.blocks\['i\-global']\.param\('([a-zA-Z_-]+)'\)/);

                return param && param[1];
            })
    ])
    .then(function(result) {
        var errors = result[0] + result[1];

        if (errors) {
            return vow.reject('\x1B[31mЕсть ошибки в использовании i-global. Ошибок ' + errors + '\x1B[39m');
        } else {
            return 'ok';
        }
    })
    .then(function() {
        process.exit();
    })
    .fail(function(errorMessage) {
        console.log(errorMessage);
        process.exit(1);
    });

function processByLine(cmdLine, getConst) {
    var deferred = vow.defer();

    exec(cmdLine, function(error, stdout) {
        if (error) {
            deferred.reject(error);
        }

        var lines = stdout.split('\n'),
            result = 0;

        for (var i = 0, l = lines.length; i < l; i++) {
            var line = lines[i],
                filePath = line.match(/^[^:]*/)[0];

            result += checkConst(getConst(line), filePath);
        }

        deferred.resolve(result);
    });

    return deferred.promise();
}

function checkConst(constName, filePath) {
    if (constName && legoConsts.indexOf(constName) === -1) {
        console.log('\x1B[31mНеизвестная переменная', constName, 'в файле', filePath, '\x1B[39m');

        return 1;
    }

    return 0;
}
