#!/usr/bin/env node

console.log('Проверка на наличие подстроки "JSON.stringify" в bemtree.js и bemhtml файлах', '\n');

var cmdline = 'grep \'JSON.stringify\' -r -n --include \\*.bemtree.js --include \\*.bemhtml -B1 desktop.blocks/';

require('child_process').exec(cmdline, function (error, stdout, stderr) {

    if (error) {
        console.error(error); process.exit(1);
    }

    var lines = stdout.split('\n'),
        rex = /ignore\s+stringify/,
        result = 0;

    for (var i = 0, l = lines.length; i < l; i++) {

        var line = lines[i],
            lineBefore = lines[i - 1] || '';

        if (/^\-\-/.test(line)) continue;

        if (/JSON\.stringify/.test(line) && !rex.test(line) && !rex.test(lineBefore)) {
            var lineArr = line.split('JSON.stringify');

            console.log(lineArr.join('\x1B[31mJSON.stringify\x1B[39m'));
            result = 1;
        }

    }

    if (result) console.log('Найдены использования JSON.stringify, для игнора добавте коментарий "ignore stringify" в той же строке или до нее');
    process.exit(result);
});
