var fs = require('fs'),
    convertMap = require('./convert-map.json'),
    fnName = process.argv[2],
    fileNames = process.argv.slice(3),
    replaceCallback = function(str, oldId) { //email-ы
        return convertMap[oldId] ? fnName + "('" + convertMap[oldId] + "')" : str;
    };

fileNames.forEach(function(fileName) {
    fs.readFile(fileName, 'utf-8', function(err, fileContent) {
        if (err) { return console.error(err); }

        fs.writeFile(
            fileName,
            /data\/t\/emails\/ru/.test(fileName)
                ? fileContent
                    .replace(/(?:http.*?)\/help\/text\.xml\?id=(\d+)/g, function(str, oldId) { //email-ы
                        return '[% ' + replaceCallback(str, oldId) + ' %]';
                    })
                : fileContent
                    .replace(/iget\((?:'|")\/help\/text\.xml\?id=(\d+)(?:'|")\)/g, replaceCallback), //остальные ссылки
            function() { /*noop*/ }
        );
    });

});
