#!/bin/bash

npm install;
read -p "Введите реальный логин пользователя для генерации страниц, пользователь не должен обладать правами суперпользователя: $IFS" ULOGIN;
export ULOGIN=$ULOGIN;
export PAGES_ROOT="../../../data/errors";
./generate-page-params.js |xargs -L 1 -I LINE bash -c \
'TEST_CMD="../../../protected/one-shot/test_cmd.pl"
declare -A services;\
services["0"]="direct";\
services["1"]="ba";\
line="LINE";args=($line);\
pageName=${args[0]}-${args[1]}-${services[${args[2]}]};\
echo "generating $pageName";
echo "$ULOGIN cmd=errorPage&status_code=${args[0]}&lang=${args[1]}&is_ba=${args[2]}"\
| $TEST_CMD --output-html 1>$PAGES_ROOT/$pageName.html 2>/dev/null'
if [[ ! -s $PAGES_ROOT/500-ru-direct.html ]] ; then
    echo 'Ошибка! Сгенерированный файл пуст.'
    exit 1;
else
    echo 'ok';
    exit 0;
fi
