module.exports = {
    meta: {
        docs: {
            description: "Запрещает использовать строки с русскими символами без iget2."
        },
        // fixable: "code",
        schema: []
    },
    create: function(context) {
        return {
            Literal: function(node) {
                if (/[а-яё]/i.test(node.value)) {
                    let current = node,
                        needToReport = true;

                    if (node.regex) { // в регулярных выражениях разрешаем русские символы
                        return;
                    }

                    while (current.parent) {
                        let parent = current.parent,
                            isIgetCall = parent.type === 'CallExpression' && parent.callee.name === 'iget2',
                            isRegExpCons = parent.type === 'NewExpression' && parent.callee.name === 'RegExp';

                        if (isIgetCall || isRegExpCons) {
                            needToReport = false;
                            break;
                        }

                        current = current.parent;
                    }

                    if (needToReport) {
                        context.report({
                            node: node,
                            message: "Строки с русскими символами должны быть обернуты в iget2: {{value}}",
                            data: {
                                value: node.value
                            }
                        });
                    }
                }
            }
        };
    }
};
