const fs = require('fs'),
      path = require('path'),
      root = path.join(__dirname, '../'),
      dataRoot = path.join(root, 'desktop.blocks/common-i18n/data'),
      i18nRoot = path.join(root, 'desktop.blocks/common-i18n/common-i18n.i18n'),
      langs = ['ru', 'en', 'ua', 'tr'],
      langMapper = lang => lang == 'ua' ? 'uk' : lang,
      tpl = data => `module.exports = ${JSON.stringify({ 'common-i18n': data }, null, 4)}`;

langs.forEach(lang => {
    const data = JSON.parse(fs.readFileSync(path.join(dataRoot, lang + '.json'), 'utf8').replace(/%s/, '')),
          targetPath = path.join(i18nRoot, langMapper(lang) + '.js');

    fs.writeFileSync(targetPath, tpl(data));
});
