const project = process.argv[2],
      path = require('path'),
      fs = require('fs'),
      Vow = require('vow'),
      vfs = require('vow-fs'),
      _ = require('lodash'),
      translationsSourcePath = path.join(__dirname, '..', 'desktop.blocks/i-utils/__i18n/i-utils__i18n.translations.json'),
      translationsSource = (function() {
          var res = JSON.parse(fs.readFileSync(translationsSourcePath));

          res['uk'] = res['ua'];

          return res;
      }()),
      jobsFilePath = path.join(__dirname, 'translations.jobs'),
      jobs = fs.readFileSync(jobsFilePath, 'utf8').split('\n').reduce((acc, job) => {
          if (job.length) {
              job = JSON.parse(job);

              if (project === 'bricks') {
                  /bricks/.test(job.i18nDir) && acc.push(job);
              } else {
                  /bricks/.test(job.i18nDir) || acc.push(job);
              }
          }

          return acc;
      }, []),
      langs = ['ru', 'uk', 'en', 'tr'],
      i18nTpl = (keyset, data) => `module.exports = ${JSON.stringify({ [keyset]: data }, null, 4)}`,
      keysetToDir = {},

      /**
       *
       * @param {String} str
       * @param {Object} exist
       * @returns {String|Object}
       */
      parseParams = function(str, exist) {
          if (!str) return '';

          if (/%s/.test(str)) {
              let paramNamesDict = ['foo', 'bar', 'baz', 'quux', 'corge', 'grault', 'garply', 'waldo', 'fred', 'plugh', 'xyzzy', 'thud'],
                  position = 0;

                  return str.replace(/%s/g, function() {
                      if (!paramNamesDict[position]) {
                          throw new Error('missing parameter name in paramNamesDict');
                      }

                      return `<i18n:param>${paramNamesDict[position++]}</i18n:param>`;
                  });
          } else if (/%{([^}]+)}/.test(str)) {
              let translationParams = [],
                  strWithI18N = str.replace(/%{([^}]+)}/g, function(match, innerValue) {
                      let [paramName, paramValue] = innerValue.split('#');

                      if (exist[paramName]) {
                          paramValue && translationParams.push({
                              val: paramValue,
                              name: paramName
                          });
                      }

                      return `<i18n:param>${paramName}</i18n:param>`;
                  });

              return translationParams.length ? { params: translationParams, str: strWithI18N } : strWithI18N;
          }
      },
      results = jobs.reduce((acc, job) => {
          keysetToDir[job.keyset] = job.i18nDir;

          langs.forEach(lang => {
              //в i-utils__i18n.translations.json украинский перевод генерится как ua
              let translationsLang = lang === 'uk' ? 'ua' : lang;

              if (job.oldKey === '%{download#Загрузить}' || job.oldKey === '%{get#Скачать}') {
                  //уникальные ключи
                  _.set(acc, [job.keyset, lang, job.newKey], lang === 'ru' ?
                      (job.oldKey === '%{get#Скачать}' ? 'Скачать' : 'Загрузить') :
                      translationsSource[translationsLang][job.oldKey]);
              } else if (job.value) {
                  //ключи с параметрами
                  let newStrWithParam = parseParams(
                      lang === 'ru' ? job.oldKey : translationsSource[translationsLang][job.oldKey],
                      job.paramsWithTranslation
                  );

                  if (typeof newStrWithParam === 'object') {
                      //параметры с переводами
                      _.set(acc, [job.keyset, lang, job.newKey], newStrWithParam.str);

                      newStrWithParam.params.forEach(param => {
                          const paramKey = job.newKey + '-param-' + param.name;

                          _.set(acc, [job.keyset, lang, paramKey], param.val);
                      });
                  } else {
                      //параметры без перевода
                      _.set(acc, [job.keyset, lang, job.newKey], newStrWithParam);
                  }

              } else {
                  //простые ключи
                  if (lang === 'ru') {
                      _.set(acc, [job.keyset, lang, job.newKey], job.oldKey);
                  } else if (translationsSource[translationsLang][job.oldKey]) {
                      _.set(acc, [job.keyset, lang, job.newKey], translationsSource[translationsLang][job.oldKey]);
                  }
              }

          });

          return acc;
      }, {});

Vow.all(
    Object.keys(results).map(keyset => {
        const i18nDir = keysetToDir[keyset];

        return vfs.makeDir(i18nDir).then(function() {
            return Vow.all(
                langs
                    .filter(lang => results[keyset][lang])
                    .map(lang => {
                        const filePath = path.join(i18nDir, lang + '.js'),
                              data = i18nTpl(keyset, results[keyset][lang]);

                        return vfs.write(filePath, data, 'utf8');
                    }));
        });
    }))
    .then(() => console.log('done'))
    .catch(e => console.log(e));
