let path = require('path'),
    fs = require('fs'),
    bemNaming = require('@bem/naming'),
    { transliterate, slugify } = require('transliteration'),
    paramNamesDict = ['foo', 'bar', 'baz', 'quux', 'corge', 'grault', 'garply', 'waldo', 'fred', 'plugh', 'xyzzy', 'thud'],
    translatiosJobsFile = path.join(__dirname, 'translations.jobs'),
    existedKeysDict = {},
    existedPhrasesDict = {},
    uniqKeyIndex = 100,
    makeKey = oldKey => {
        if (existedPhrasesDict[oldKey]) {
            return existedPhrasesDict[oldKey];
        }

        let res = slugify(oldKey).split('-').slice(0,4).join('-');

        if (existedKeysDict[res]) {
            res += '-' + uniqKeyIndex++;
        }

        existedKeysDict[res] = true;
        existedPhrasesDict[oldKey] = res;

        return res;
    },
    translationJobs = [];

fs.writeFileSync(translatiosJobsFile, '');

module.exports = function(fileInfo, api, options) {
    const j = api.jscodeshift,
          entityName = path.basename(fileInfo.path).replace(/\..+/, ''),
          techName = path.basename(fileInfo.path).replace(/[^.]+/,'').slice(1),
          entity = bemNaming.parse(entityName),
          keyset = entity.block,
          blockDirPath = path.dirname(fileInfo.path).split(path.sep).filter(chunk => !chunk.startsWith('_')).join(path.sep),
          i18nDir = path.resolve(/bricks/.test(blockDirPath) ?
              ('bricks.translations/' + keyset) :  // нужны ли блоки?
              blockDirPath, keyset + '.i18n'),
          processSimpleKey = oldKey => {
              let newKey = makeKey(oldKey),
                  newArgs = [j.literal(keyset), j.literal(newKey), j.literal(oldKey)];

              translationJobs.push({
                  oldKey,
                  newKey,
                  keyset,
                  i18nDir
              });

              return j.callExpression(j.identifier('iget2'), newArgs);
          };

    let result = j(fileInfo.source)
            .find(j.CallExpression)
            .filter(p => p.value.callee.name == 'iget')
            .replaceWith(p => {
                let args = p.value.arguments,
                    oldKey = args[0].value,
                    newArgs;

                if (args[0].type != 'Literal') {
                    console.log("wrong iget key", j(p).toSource());
                    return p.value;
                }

                try {
                    if (oldKey === '%{get#Скачать}' || oldKey === '%{download#Загрузить}') {
                        return processSimpleKey(oldKey);
                    } else if (args.length == 1) {
                        return processSimpleKey(oldKey);
                    } else {
                        //смешанных анонимных и позиционных параметров не встречается, поэтому отдельно обрабатывать случаи безопасно
                        if (/%s/.test(oldKey)) {
                            let paramsCount = args.length - 1,
                                properties = paramNamesDict.slice(0, paramsCount).map((key, n)=> {
                                    return j.property('init', j.identifier(key), args[n + 1]);
                                }),
                                newKey = makeKey(oldKey),
                                position = 0,
                                value = oldKey.replace(/%s/g, function() {
                                    if (!paramNamesDict[position]) {
                                        throw new Error('missing parameter name in paramNamesDict');
                                    }

                                    return `<i18n:param>${paramNamesDict[position++]}</i18n:param>`;
                                }),
                                fancyValue;

                            position = 0;
                            fancyValue = oldKey.replace(/%s/g, function() {
                                if (!paramNamesDict[position]) {
                                    throw new Error('missing parameter name in paramNamesDict');
                                }

                                return `{${paramNamesDict[position++]}}`;
                            });

                            newArgs = [j.literal(keyset), j.literal(newKey), j.literal(fancyValue), j.objectExpression(properties)];

                            translationJobs.push({
                                oldKey,
                                newKey,
                                keyset,
                                i18nDir,
                                value
                            });
                        } else if(/%{[^}]+}/.test(oldKey)) {
                            let params = {},
                                paramsWithIget = {},
                                paramsWithTranslation = {},
                                newKey = makeKey(oldKey), //TODO пайпы
                                value = oldKey.replace(/%{([^}]+)}/g, function(match, innerValue) {
                                    let [paramName, paramValue] = innerValue.split('#');

                                    params[paramName] = paramValue;

                                    return `<i18n:param>${paramName}</i18n:param>`;
                                }),
                                fancyValue = oldKey.replace(/%{([^}]+)}/g, function(match, innerValue) {
                                    let [paramName, paramValue] = innerValue.split('#');

                                    return `{${paramName}}`;
                                }),
                                context = Object.keys(params).reduce((res, key) => {
                                    if (params[key]) {
                                        const paramKey = newKey + '-param-' + key;

                                        res.push(`${key} - ${params[key]}`);

                                        paramsWithIget[key] = isFinite(params[key].replace(/%/g, '')) ?
                                            j.literal(params[key]) :
                                            j.callExpression(j.identifier('iget2'), [j.literal(keyset), j.literal(paramKey), j.literal(params[key])]);
                                    }
                                    return res;
                                }, []).join('; '),
                                tailArg;

                            switch(args[1].type) {
                            case 'Identifier':
                                tailArg = args[1];
                                break;
                            case 'ObjectExpression':
                                let isBemtree = techName == 'bemtree.js',
                                    newProperties = args[1].properties.map(p => {
                                        let wrapWithApply = value => {
                                            switch(techName) {
                                            case 'js':
                                                return value[0].callee.type === 'FunctionExpression' ?
                                                    value[0] :
                                                    j.callExpression(j.memberExpression(j.identifier('BEMHTML'), j.identifier('apply')), value);
                                            case 'bemhtml.js':
                                                // return j.callExpression(j.identifier('applyCtx'), value);
                                                return value[0];
                                            case 'bemtree.js':
                                                return value[0]; //todo
                                            case 'utils.js':
                                                return value[0]; //в utils нет случаев, где нужно оборачивать в apply
                                            default:
                                                throw new Error('unknown tech');
                                            }
                                        };

                                        // if (['MemberExpression', 'FunctionExpression', 'ObjectExpression'].indexOf(p.value.type) == -1) {
                                        //     console.log('LABEL', p.value.type, fileInfo.path, j(p).toSource());
                                        // }

                                        switch(p.value.type) {
                                        case 'CallExpression': {
                                            if (p.value.callee.type == 'MemberExpression' && p.value.callee.property.name == 'bind') { //bind
                                                return j.property('init', p.key, wrapWithApply([j.callExpression(p.value, [params[p.key.name] ?
                                                    j.literal(params[p.key.name]) :
                                                    j.identifier("undefined")])]));
                                            } else {
                                                return p;
                                            }
                                        }
                                        case 'FunctionExpression': {
                                            const name = p.key.name || (p.value.params[0] && p.key.value);

                                            params[name] && (paramsWithTranslation[name] = params[name]);

                                            return j.property('init', p.key, wrapWithApply([j.callExpression(p.value, [
                                                params[name] ? paramsWithIget[name] : j.identifier("")
                                            ])]));
                                        }
                                        case 'ObjectExpression': {
                                            return j.property('init', p.key, wrapWithApply([p.value]));
                                        }
                                        default:
                                            return p;
                                        }
                                    });

                                if (context.length) {
                                    newProperties.push(j.property('init', j.identifier('context'), j.literal(context)));
                                }

                                try{
                                    tailArg = j.objectExpression(newProperties);
                                } catch(e) {
                                    console.log('properties errors', newProperties);
                                    throw e;
                                }
                                break;
                            }

                            translationJobs.push({
                                oldKey,
                                newKey,
                                keyset,
                                i18nDir,
                                value,
                                paramsWithTranslation
                            });

                            newArgs = [j.literal(keyset), j.literal(newKey), j.literal(fancyValue), tailArg];
                        } else {
                            console.log('unknown case', j(p).toSource());
                            return p.value;
                        }
                    }

                    return j.callExpression(j.identifier('iget2'), newArgs);
                } catch (e) {
                    console.log(j(p).toSource());
                    console.log('-----------');
                    console.log(e);
                    return p.value;
                }
            })
            .toSource({ wrapColumn: 120, quote: 'single' });

    fs.appendFileSync(translatiosJobsFile, translationJobs.map(job => JSON.stringify(job)).join('\n') + '\n', 'utf8');

    return result;
};
