// #!/usr/bin/env node

const cluster = require('cluster'),
    exec = require('child_process').exec,
    numCPUs = require('os').cpus().length,
    fs = require('fs'),
    namesDir = ['desktop.blocks', 'touch.blocks', 'common.blocks', 'node_modules/bricks/source.blocks'];

function getBlocksName() {
    let blocksDir = {};

    namesDir.forEach(dir => {
        fs.readdirSync(dir).map(name => {
            const path = dir + '/' + name;

            if (blocksDir[name]) {
                blocksDir[name] += ' ' + path;
            } else {
                blocksDir[name] = path;
            }
        });
    });

    return Object.keys(blocksDir).reduce((res, key) => {
        res.push(blocksDir[key]);

        return res;
    }, []);
}

function chunkArray(arr, chunk) {
    let i, j, tmp = [];

    for (i = 0, j = arr.length; i < j+1; i += chunk) {
        const item = arr.slice(i, i + chunk);

        item.length && tmp.push(item);
    }

    return tmp;
}

function transform(blocks) {
    return new Promise((resolve, reject) => {
        let findBlocks = exec('jscodeshift ' + blocks + ' -t utils/iget-to-bem-i18n.js --run-in-band');

        findBlocks.stdout
            .on('data', data => {
                console.log(data);
                resolve();
            })
            .on('error', e => reject(e));
    });
}

if (cluster.isMaster) {
    cluster.on('fork', worker => {
        worker.on('message', msg => {
            // console.log('Master received %j from worker %s.', msg, worker.id);
            msg === 'disconnect' && worker.disconnect();
        });
    });

    const blocksName = getBlocksName();
    const chunk = blocksName.length > numCPUs ? Math.ceil(blocksName.length / numCPUs) : 1;
    const chunkData = chunkArray(blocksName.sort(), chunk);

    for (let i = 0; i < chunkData.length; i++) {
        cluster
            .fork()
            .send({ blocks: chunkData[i].join(' ') });
    }

} else if (cluster.isWorker) {
    process.on('message', (message) => {
        // console.log('Worker: "processing" ', message.blocks);

        transform(message.blocks)
            .then(data => process.send('disconnect'))
            .catch(e => console.log(e));
    });
}
