// Работа с ветками Танкера
// документация — https://doc.yandex-team.ru/Tanker/api-reference/concepts/operations-branches.html

//Откатиться до ревизии
//curl -X POST -H "AUTHORIZATION: OAuth <token>" "https://tanker-api.yandex-team.ru/admin/project/direct2/branch/DIRECT-76450/rollback/101b0b4d03a2021531112a48d550ec7773516061/"
// SoftMerge — у меня не заработал, может и не нужен
// let url = 'curl -X POST -H \"' + AUTHTOKEN + '\" --form "project-id=direct2" --form "dest=' + dest +'" --form "source=' + branch +'" --header "Expect: " "https://tanker-api.yandex-team.ru/branches/softmerge/"';

require('dotenv').config({ path: '/etc/direct-tokens/twilight/.env' });

const fs = require('fs');
const cp = require('child_process');
const exec = cp.exec;
const _ = require('lodash');
const args = require('args');

args
    .option('resolve', 'Слияние веток, после решение конфликтов', undefined, Boolean)
    .option('token', 'Авторизационные токен для робота', process.env.TWILIGHT_TANKER_TOKEN)
    .command('create', 'Создает ветку Танкера', createBranch, ['c'])
    .command('delete', 'Удаляет ветку Танкера', deleteBranch)
    .command('diff', 'Сравнивает две ветки Танкера, результат форматирует, выводит в консоль', getDiffBranches, ['d'])
    .command('merge', 'Слияние веток. Конфликты сохраняет в resolve.json. С 3-м аргументом отправляет resolve.json', merge, ['m'])
    .example('node tanker-branch.js create br1', 'Создать ветку из master')
    .example('node tanker-branch.js create br1 br2', 'Создать ветку из ветки br2')
    .example('node tanker-branch.js create br1 hash', 'Создать ветку с ревизии')
    .example('node tanker-branch.js merge br1 br2', 'Слияние веток (b1 => b2)')
    .example('node tanker-branch.js merge br1 br2 -r', 'Слияние веток (b1 => b2) после решение конфликтов в resolve.json');

const flags = args.parse(process.argv);

/**
 * Формирует token
 * @param {string} token
 * @returns {string}
 */
function getAuthToken(token) {
    return `AUTHORIZATION: OAuth ${token}`;
}

/**
 * Создает ветку Танкера
 * @param command
 * @param name — новое имя ветки
 * @param ref — имя ветки или номер ревизии с которой делать копию
 * @param options
 * @returns {Promise<any>}
 */
function createBranch(command, [name, ref], options) {
    let branch = {
        name: name,
        ref: ref || 'master'
    };

    return new Promise((resolve, reject) => {
        let url = `curl -H "${getAuthToken(options.token)}" -d '${JSON.stringify(branch)}' "https://tanker-api.yandex-team.ru/admin/project/direct2/branch/"`;

        exec(url).stdout
            .on('data', data => {
                console.log('done');
                resolve();
            })
            .on('error', e => reject(e))
    });
}

/**
 * Удаляет ветку Танкера
 * @param {string} command
 * @param {string} name
 * @param {object} options
 * @returns {*}
 */
function deleteBranch(command, name, options) {
    if (name === 'master') return console.log('Нельзя удалять master');

    return new Promise((resolve, reject) => {
        let url = `curl -X DELETE -H "${getAuthToken(options.token)}" "https://tanker-api.yandex-team.ru/admin/project/direct2/branch/${name}/"`;

        exec(url).stdout
            .on('data', data => {
                console.log(data);
                resolve();
            })
            .on('error', e => reject(e));
    });
}

/**
 * Сравнивает две ветки Танкера, форматирует полученный результат
 * @param {string} command
 * @param {string} br1
 * @param {string} br2
 * @param {object} options
 * @returns {Promise}
 */
function getDiffBranches(command, [br1, br2], options) {
    return new Promise((resolve, reject) => {
        let json = '';
        let error = '';

        const curl = cp.spawn('curl', [
            '--silent',
            '-H', 'Content-Type: application/json',
            '-H', getAuthToken(options.token),
            `https://tanker-api.yandex-team.ru/diff/?project-id=direct2&refa=${br1}&refb=${br2}`
        ]);

        curl.stdout.on('data', (data) => {
            json += data.toString();
        });

        curl.stderr.on('data', (data) => {
            error+= data.toString();
        });

        curl.on('close', (code) => {
            if (code) {
                console.log(`child process exited with code ${code}`);
                reject(new Error(error));
            } else {
                try {
                    resolve(JSON.parse(json));
                } catch (err) {
                    reject(err);
                }
            }
        });
    })
    .then(data => {
        if (_.keys(data).length) {
            _getFormattedChanges(data);
        }
    }, err => console.log(err.toString()));
}

/**
 * Слияние веток
 * @param command
 * @param {string} branch — Что
 * @param {string} dest — Куда
 * @param options
 * @returns {Promise<any>}
 */
function merge(command, [branch, dest], options) {
    return new Promise((resolve, reject) => {
        const curl = cp.spawn('curl', [
            '--silent',
            '-X', 'POST',
            '-H', getAuthToken(options.token),
            '-d', options.resolve ? '@resolve.json' : "",
            `https://tanker-api.yandex-team.ru/branches/merge/?project-id=direct2&source=${branch}&dest=${dest}`
        ]);

        curl.stdout
            .on('data', data => {
                console.log(JSON.parse(data));
                resolve(JSON.parse(data));
            })
            .on('error', e => reject(e));
    })
    .then(data => {
        fs.writeFileSync('resolve.json', JSON.stringify(data, null, 4));
    });
}

/**
 * Фильтрует данные
 * возвращает их урезанный формат
 * @param {Object} data
 */
function _getFormattedChanges(data) {
    const keysets = data.keysets;
    // const fileName = 'tmp/' + name + '-diff-' + ref + '.json';

    let res = _.keys(keysets).reduce((res, keyset) => {
        if (!keyset.match(/^dna\:/)) { // не обращаем внимание на dna
            let allKeys = keysets[keyset].keys;

            res[keyset] = {};

            allKeys && _.keys(allKeys).forEach(key => {

                if (_.includes(_.keys(allKeys[key]), 'translations')) { // изменился текст фраз

                    _.keys(allKeys[key].translations).forEach(lang => {
                        if (allKeys[key].translations[lang] && allKeys[key].translations[lang].form) {
                            let form =  allKeys[key].translations[lang].form;

                            res[keyset][key] || (res[keyset][key] = {});
                            res[keyset][key].action = 'change';
                            res[keyset][key][lang] || (res[keyset][key][lang] = {});

                            res[keyset][key][lang]['previous'] = form.a;
                            res[keyset][key][lang]['current'] = form.b;
                        }
                    })
                } else if (_.includes(_.keys(allKeys[key]), 'meta')) { // ключ удалили
                    if (allKeys[key].meta.is_deleted) {
                        res[keyset][key] = { is_deleted: true };
                    }
                } else if (_.includes(_.keys(allKeys[key]), 'action') && allKeys[key].action === 'added') { // ключ добавили

                    _.keys(allKeys[key].b.translations).forEach(lang => {
                        let addedForm = allKeys[key].b.translations[lang].form;

                        res[keyset][key] || (res[keyset][key] = {});
                        res[keyset][key].action = 'added';

                        if (addedForm) { // добавили текст к новому ключу
                            res[keyset][key][lang] || (res[keyset][key][lang] = {});
                            res[keyset][key][lang]['current'] = addedForm;
                        }
                    });
                }
            })
        }

        return res;
    }, {});

    console.log(JSON.stringify(res, null, 4));

    // fs.writeFileSync(fileName, JSON.stringify(res, null, 4));
}
