require('dotenv').config({ path: '/etc/direct-tokens/twilight/.env' });

const { publish } = require('auto-issues');
const { TankerApi } = require('tanker-branch');

const { getSvnBranch, getStartrekClient, mergeTankerBranches } = require('./utils');

const forceMerge = process.argv.includes('--force');
const PROJECT = 'direct2';
const tankerApi = new TankerApi(PROJECT, process.env.TWILIGHT_TANKER_TOKEN);

const branchName = getSvnBranch();

const issueClient = getStartrekClient(process.env.TWILIGHT_OAUTH_TOKEN, branchName);

issueClient.get().then(([issue]) => {

    if (!issue) {
        console.log(`задача не переводы ветки "${branchName}" не найдена`);
        process.exit(1);
    }

    if (!isTicketStatusValid(issue.getField('status'))) {
        console.log(`задача на переводы ветки "${branchName}" не закрыта! Ссылка на задачу https://st.yandex-team.ru/${issue}.`);
        process.exit(1);
    }

    return mergeTankerBranches(tankerApi, branchName, 'master')
        .then(() => issue);

}).then(issue => {
    issue
        .setField('commited', 'Да');

    return publish(issue)
}).then(issue => {
    console.log(`Тикет: https://st.yandex-team.ru/${issue.getKey()}`);
    console.log('установлен статус "закоммичено"');
});

function isTicketStatusValid({ key }) {
    // пример статуса
    // {
    //     self: 'https://st-api.yandex-team.ru/v2/statuses/30',
    //     id: '30',
    //     key: 'pending',
    //     display: 'В ожидании'
    // }
    if (key.toLowerCase() === 'closed' || forceMerge) {
        return true;
    }
    return false;
}
