const { IssueClient } = require('auto-issues');
const {execSync} = require('child_process');
const fs = require('fs');
const path = require('path');
const { MergeError } = require('tanker-branch/lib/MergeError');

function getSvnBranch() {
    const prefix = 'branches/direct/perl';

    const [,base1, base2, base3, branch] = execSync('svn info|grep "Relative URL"|cut -c16-', {
        cwd: __dirname
    }).toString().split('/');
    const base = [base1, base2, base3].join('/');

    if (base !== prefix) {
        throw new Error(`invalid prefix: ${base}`);
    }

    return branch;
}

function getStartrekClient(token, branchName) {
    return new IssueClient(token, {
        queue: 'TRANSLATE',
        branch: branchName,
        type: 'translation',
        components: [50937]
    }, {
        host: 'https://st-api.yandex-team.ru', // optional
        timeout: 20000 // ms, optional
    });
}

function mergeTankerBranches(tankerApi, branchFrom, branchTo) {
    return tankerApi.merge(branchFrom, branchTo)
        .then(() => {
            console.log(`ветка "${branchFrom}" влита в ветку "${branchTo}" танкера`);
        })
        .catch(err => {
            const confiltsFilePath = path.join(path.resolve(__dirname), 'conflicts.json');

            if (err instanceof MergeError) {
                fs.writeFileSync(confiltsFilePath, JSON.stringify(err.conflicts, undefined, 2), 'utf8');
            }

            throw new Error(`Merge conflicts: см. файл: ${confiltsFilePath}`);
        });
}

module.exports = {
    getSvnBranch,
    getStartrekClient,
    mergeTankerBranches
};
