var fs = require('fs'),
    BLOCKS_DIRECTORIES = ['common.blocks', 'desktop.blocks'],
    EXCLUDES = [
        'input', 'checkbox', 'select', 'radiobox', 'button', 'popup', 'link', 'b-link',
        'b-dev-profile-log-info', 'b-dev-info', 'l-head', 'b-lang-switcher',
        'b-checkboxes-group', 'b-icon-text', 'b-page-title'
    ],
    exec = require('child_process').exec,
    trunk = 'svn+ssh://svn.yandex.ru/direct/trunk/data2',
    revision = 'r97351',
    branch,
    tickets = [];


function startCLI() {
    exec('svn info', function(err, stdout) {
        var name,
            path,
            rev;

        err && console.log('\033[37;1;31m' + err + '\033[0m');

        branch = /URL:\s*(\S+)\n/.exec(stdout)[1];

        if (process.argv.length === 2 || process.argv[2] === 'help') {
            showHelp();
        } else {
            name = process.argv[2];
            if (process.argv.length === 4) {
                revision = process.argv[3];
            } else {
                rev = getRevision(name);
                rev && (revision = rev);
            }

            showDiff(name);
        }
    });
}

function getRevision(name) {
    var path,
        rev,
        fileExists = BLOCKS_DIRECTORIES.some(function(dir) {
        path = dir + '/' + name + '/' + name + '.md';
        return fs.existsSync(path);
    });

    if (fileExists) {
        rev = /^\/?\/?\s*(r?\d+)\n/i.exec(fs.readFileSync(path, 'utf8'));
        rev = rev && rev[1];
    }

    return rev;
}

function showHelp() {
    console.log('\033[37;1;32mТулза отображает diff по блоку и всем его зависимостям между data2 и data3 экземплярами \033[0m');
    console.log('\033[37;1;34mА именно изменения в транке data2 относительно data3 текущего бранча для js/css/bemtree и начиная с даты создания директории в data3 для bemhtml\033[0m');
    console.log('Параметры запуска: \033[37;1;33mnode to-islands4-diff <block-name> <create-revision>\033[0m');
    console.log('Пример запуска: \033[37;1;33mnode ./utils/to-islands4-diff b-banner-preview r97351\033[0m');
    console.log('\033[37;1;31mЗапускать из data3\033[0m');
}

function showDiff(blockName) {
    var blockDirs = getAllBlockDirectory(blockName);

    if (!blockDirs.length) {
        console.log('\033[37;1;31m' + 'Блок не найден в data3' + '\033[0m');

        return;
    }

    getDepsListForBlock(blockName, function(res) {
        res.push(blockName);
        console.log('\033[37;1;33m', 'Изменения в data2 относительно data3 для js/css/bemtree и в транке для bemhtml', '\033[0m');
        res.forEach(function(block) {
            var dirs = getAllBlockDirectory(block),
                rev = getRevision(block);

            if (!dirs.length) return;

            dirs.forEach(function(dir, j) {
                getDiffByDir(dir, function() {
                    console.log('\033[37;1;33m', 'Блок ', dir, '\033[0m');
                }, rev);
            });
        });


    }, EXCLUDES.concat([blockName]));


}

function getDepsListForBlock(blockName, callback, existsList) {
    var depsList = [],
        blockDirs = getAllBlockDirectory(blockName),
        recFunc = function(i, length) {
            getDepsListForBlock(depsList[i], function(res) {
                depsList = depsList.concat(res);
                if (i === length - 1) {
                    callback(depsList)
                } else {
                    recFunc(i + 1, length);
                }
            }, depsList.concat(existsList));
        };

    if (!blockDirs.length) {
        callback([]);

        return;
    }

    existsList || (existsList = []);

    getAllDepsFileForBlock(blockDirs, function(depsFiles) {
        depsFiles.forEach(function(file) {
            depsList = depsList.concat(parseDepsFile(file));
        });

        depsList = depsList.reduce(function(accum, current) {
            existsList.indexOf(current) === -1 && accum.indexOf(current) === -1 && accum.push(current);

            return accum;
        }, []);

        if (depsList.length) {
            recFunc(0, depsList.length);
        } else {
            callback([]);
        }
    });
}

function parseDepsFile(path) {
    var file = fs.readFileSync(path, 'utf8'),
        reg = /block\s*:\s*'([\S-]+)'/g,
        cur,
        result = [];

    while (cur = reg.exec(file)) {
        result.push(cur[1]);
    }

    return result;
}

function getAllBlockDirectory(blockName, root) {
    return BLOCKS_DIRECTORIES.reduce(function(accum, dir) {
        var path = (root ? root + '/' : '') + dir + '/' + blockName;

        fs.existsSync(path) && accum.push(dir + '/' + blockName);

        return accum;
    }, []);
}

function getDiffByDir(dir, callback, blockRev) {
    var data2Dir = dir;

    blockRev = blockRev || revision;

    exec('svn diff ' + trunk + '/' + data2Dir + ' -r ' + blockRev + ':HEAD | filterdiff --clean -i *.bemhtml', function(err, svnOut) {
        data2Dir = '../data2/' + data2Dir;
        exec('diff -r ' + dir + ' ' + data2Dir + ' --exclude=\'*.deps.js\' --exclude=\'*.md\'', function(err, diff) {
            callback();
            console.log(diff
                .replace(/Common subdirectories.+\n/g, '')
                .replace(/\ndiff.+?\.\./g, '\n')
                .replace(/\n>/g, '\033[37;1;31m\nD2\033[0m')
                .replace(/\n</g, '\033[37;1;32m\nD3\033[0m'));
            svnOut && console.log('\033[37;1;34m\nBEMHTML DIFF\033[0m\n', svnOut);
        });
    });
}

function getAllDepsFileForBlock(blockDirectories, callback) {
    return exec('find ' + blockDirectories.join(' ') + ' -name *.deps.js', function(err, stdout) {
        err && console.log('\033[37;1;31m' + err + '\033[0m');
        callback(stdout.split('\n').filter(function(item) {
            return !!item;
        }));
    });
}

startCLI();
