iget = function(val) {
    return val;
};

var cp = require('child_process'),
    Vow = require('vow'),
    PERL_COMMAND_TEMPLATE = 'perl -MJSON -Mmy_inc=for,protected -MDirect::Template -E \'my $p = Direct::Template::predefine(); $output=$p->{%NAME%}->(%PARAMS%); say encode_json( { output => $output } );\'',
    UTILS_PATH_TEMPLATE = '../desktop.blocks/i-utils/__%ELEM%/i-utils__%ELEM%.utils.js',
    testsSets = {
        formatInt: {
            elemName: 'format',
            perlAlias: 'format_int',
            paramsSets: [
                [],
                [0],
                [0.9999999],
                [1234123456789.123456],
                [1.4],
                [1.5],
                [1.55],
                [1.54],
                { perl: [1234123456789.123456, { separator: '_X_' }], js: [1234123456789.123456, '_X_'] }
            ]
        },
        round2s: {
            elemName: 'format',
            paramsSets: [
                [],
                [''],
                [11.86 * 8.1 / 1.2],
                [-11.86 * 8.1 / 1.2],
                [1.2 / 0.1 * 0.1],
                [1 / 3 * 2],
                [96.072],
                [0.005],
                [1664.2],
                [1234],
                [1.25],
                [10],
                [0],
                [0.554],
                [0.5549],
                [0.555],
                [0.556],
                [-0.556],
                [-0.555],
                [-0.5549],
                [-0.554],
                [1 / 3 * 3],
                [-1 / 3 * 3],
                [1 / 9],
                [-1 / 9]
            ]
        },
        formatPrice: {
            elemName: 'format',
            perlAlias: 'format_price',
            paramsSets: [
                [],
                [0],
                [0.9999999],
                [1234123456789.123456],
                { perl: [1234567.8901, { separator: '___' }], js: [1234567.8901, '___'] },
                { perl: [1234567.8901, { separator: '' }], js: [1234567.8901, ''] },
                [1e-7 * 0.9],
                [1e-7 * 1.1],
                [0.554],
                [0.5549],
                [0.555],
                [0.556],
                [-0.556],
                [-0.555],
                [-0.5549],
                [-0.554],
                [1 / 3 * 3],
                [-1 / 3 * 3],
                [1 / 9],
                [-1 / 9]
            ]
        },
        formatShowsOrMoney: {
            elemName: 'format',
            perlAlias: 'format_units',
            paramsSets: [
                [],
                ['-'.charCodeAt(0)],
                [0],
                [0, 'money'],
                [0, 'shows'],
                [0.9999999],
                [0.9999999, 'money'],
                [0.9999999, 'shows'],
                [1234123456789.123456],
                [1234123456789.123456, 'money'],
                [1234123456789.123456, 'shows'],
                [1234567.8901, 'money'],
                [1234567.8901, 'shows'],
                [1e-7 * 0.9, 'money'],
                [1e-7 * 0.9, 'shows'],
                [1e-7 * 1.1, 'money'],
                [1e-7 * 1.1, 'shows']
            ]
        },
        formatFileSize: {
            elemName: 'format-file-size',
            perlAlias: 'format_file_size',
            paramsSets: [
                [0],
                [1],
                [1000],
                [10000.01]
            ]
        },
        getSortHeaderLink: {
            elemName: 'table',
            perlAlias: 'get_sort_table_header',
            jsNameSpace: 'table',
            paramsSets: [
                [],
                {
                    perl: [
                        'login',
                        'MyLogin',
                        'login'
                    ],
                    js: [{
                        col: 'login',
                        caption: 'MyLogin',
                        defCol: 'login'
                    }]
                },
            // из-за того что порядок ключей при обходе объекта не гарантируются, результирующая строка получается разная,
            // при том что набор GET-параметров совпадает, поэтому сейчас эти тесты отключаю (collapsus)
/*
                {
                    perl: [
                        'login',
                        'MyLogin',
                        'login',
                        {  //FORM
                            detail: 'Yes',
                            types: '',
                            target_all: 1,
                            cmd: 'showCampStat',
                            cid: 263,
                            with_nds: '',
                            ulogin: 'holodilnikru'
                        }
                    ],
                    js: [
                        {
                            col: 'login',
                            caption: 'MyLogin',
                            defCol: 'login'
                        },
                        { //FORM
                            detail: 'Yes',
                            target_all: 1,
                            types: '',
                            cmd: 'showCampStat',
                            with_nds: '',
                            cid: 263,
                            ulogin: 'holodilnikru'
                        }
                    ]
                },
                {
                    perl: [
                        'login',
                        'MyLogin',
                        'login, column2',
                        {
                            detail: 'Yes',
                            types: '',
                            target_all: 1,
                            cmd: 'showCampStat',
                            cid: 263,
                            with_nds: '',
                            ulogin: 'holodilnikru',
                            sortparam: 'login'
                        },
                        {
                            anchorset: 'grp1',
                            anchor: 'grp1',
                            url_param: 'sortparam',
                            dont_remove_page_from_url: 1
                        }
                    ],
                    js: [
                        {
                            col: 'login',
                            caption: 'MyLogin',
                            defCol: 'login, column2',
                            options: {
                                anchorset: 'grp1',
                                anchor: 'grp1',
                                urlParam: 'sortparam',
                                dontRemovePageFromUrl: true
                            }
                        },
                        {
                            detail: 'Yes',
                            types: '',
                            target_all: 1,
                            cmd: 'showCampStat',
                            cid: 263,
                            with_nds: '',
                            ulogin: 'holodilnikru',
                            sortparam: 'login'
                        }
                    ]
                },
*/
                {
                    perl: [
                        'login',
                        'MyLogin',
                        'login',
                        {},
                        {
                            default_reverse: 1
                        }
                    ],
                    js: [
                        {
                            col: 'login',
                            caption: 'MyLogin',
                            defCol: 'login',
                            options: {
                                defaultReverse: 1
                            }
                        },
                        {}
                    ]
                },
                {
                    perl: [
                        'login',
                        'MyLogin',
                        'login',
                        {},
                        {
                            default_reverse: 1
                        }
                    ],
                    js: [
                        {
                            col: 'login',
                            caption: 'MyLogin',
                            defCol: 'login',
                            options: {
                                defaultReverse: 1
                            }
                        },
                        {}
                    ]
                }
            ]
        },
        getGeoNames: {
            elemName: 'regions',
            perlAlias: 'get_geo_names',
            jsNameSpace: 'regions',
            paramsSets: [
                [],
                [''],
                [0],
                [1],
                [2],
                [999999999999999],
                ['-1, -10723'],
                ['1, -10723, -214, 10995, -1107, -970'],
                ['1,-10723,-214,-215,-10739,11235,21949'],
                [116],
                ['3,17,10995,-1107,-970,-1058,11029,-238,-971,11070,11079,-972,11131,-240,11146'],
                ['3,17', '; '],
                ['1,10174,-969,-10867', '/']
            ]
        }
    };


// stub for i-utils
global.u = {
    register: function(obj) {
        this.extend(this, obj);
    },

    extend: function(dest, src) {
        Object.keys(src).forEach(function(field) {
            dest[field] = src[field];
        });

        return dest;
    },

    consts: function(name) {},

    _: {
        extend: function(dest, src) {
            if (!src) return dest;

            return u.extend(dest, src);
        },

        isArray: function(obj) {
            return Array.isArray(obj);
        }
    }
};

//регистрирует дерево регионов
//считывает и выполняет файл регионов и выполняет регистрацию
// внутри файла регионов происходит регистрация дерева в i-utils
(new Function(fs.readFileSync('./desktop.bundles/direct/direct.ru.regions.js')))();

function exec(cmd) {
    var promise = Vow.promise();

    cp
        .exec(cmd, function(error) {
            error && promise.reject(error);
        })
        .stdout.on('data', function(data) {
            promise.fulfill(data);
        });

    return promise;
}

function checkCurrentDirectory() {
    return exec('pwd').then(function(data) {
        if (data.match(/data3/)) {
            PERL_COMMAND_TEMPLATE = 'cd ../; ' + PERL_COMMAND_TEMPLATE;
        }
    });
}

function extractParamsForPerl(params) {
    return params.reduce(function(res, param) {

        return res + (res ? ',' : '') +
            (typeof param === 'object' ?
                JSON.stringify(param).replace(/:/g, '=>') :
                typeof param === 'string' ?
                    '"' + param + '"' :
                    param);
    }, '');
}

function execPerlFunction(name, params) {
    var cmd = PERL_COMMAND_TEMPLATE
        .replace('%NAME%', name)
        .replace('%PARAMS%', extractParamsForPerl(params));

    return exec(cmd).then(function(data) {
        return JSON.parse(data).output;
    });
}

function checkJsPortVersion(name, params) {
    var paramsSets = params.paramsSets,
        perlFuncAlias = params.perlAlias,
        jsNameSpace = params.jsNameSpace;

    return Vow.all(paramsSets.map(function(params) {

        return execPerlFunction(perlFuncAlias || name, params.perl || params).then(function(perl) {
            var uObj = (u[jsNameSpace] || u),
                js = uObj[name].apply(uObj, params.js || params),
                res = js == perl;

            res || console.log('\x1b[31mОшибка:', '\n perl:', perl, '\njs:   ',  js, '\x1b[0m');

            return res;
        });
    })).then(function(res) {
        console.log(name, '–', res.filter(function(r) { return r }).length, 'из', res.length, 'пройдены');
    });
}

checkCurrentDirectory()
    .then(function() {
        var name = process.argv[2];

        if (!name) {

            return Vow.all(Object.keys(testsSets).map(function(funcName) {
                require(UTILS_PATH_TEMPLATE.replace(/%ELEM%/g, testsSets[funcName].elemName));

                return checkJsPortVersion(funcName, testsSets[funcName]);
            }));
        } else {
            require(UTILS_PATH_TEMPLATE.replace(/%ELEM%/g, testsSets[name].elemName));

            return checkJsPortVersion(name, testsSets[name]);
        }
    })
    .done();
