#! /usr/bin/env bash

declare -i RESULT=0

if [[ -z ${@+x} ]]
then
    path="desktop.blocks"
    es_lint_path="."
else
    if [[ -n "$@" ]]
    then
        path="$@"
        es_lint_path="$@"
    else
        exit 0
    fi
fi

if [ "$BUILD_ENV" == "teamcity" ]
then
    js_hint_reporter="--reporter ./node_modules/jshint-teamcity/teamcity.js"
    jscs_reporter="--reporter ./node_modules/jscs-teamcity-reporter/teamcity-reporter.js"
    eslint_reporter="--format ./node_modules/eslint-teamcity/index.js"
fi

echo -e "\n\njsHint\n"
./node_modules/.bin/jshint $js_hint_reporter $path
RESULT+=$?

echo -e "\n\njscs\n"
./node_modules/.bin/jscs $path $jscs_reporter
RESULT+=$?

echo -e "\n\neslint\n"
./node_modules/.bin/eslint $eslint_reporter --rulesdir utils/eslint-rules $es_lint_path --quiet
RESULT+=$?

exit $RESULT
