#!/bin/bash

revFileName="bemtree-xjst-convert-rev";
DT="svn+ssh://svn.yandex.ru/direct/trunk";
HEAD=$(svn info $DT | grep "^Revision:" | sed "s/Revision: //");
startRev=$(tail -n 1 ${revFileName});
xjstFiles=$(svn diff ${DT}/data3 -r ${startRev}:${HEAD}  --summarize | grep "bemtree.xjst" | sed "s/.\s*//");
diffFIleName="bemtree_${startRev}-${HEAD}.diff";

if ! [ -z "$xjstFiles" ]
then
    svn diff ${xjstFiles} -r ${startRev}:$HEAD > ${diffFIleName};
else
    touch ${diffFIleName}
fi

echo ${HEAD} | tee -a ${revFileName}

exit 0;
