CREATE TABLE `buildbot_builds` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `builder` varchar(30) NOT NULL,
  `build_number` int(10) NOT NULL,
  `revision` int(10) NOT NULL,
  `branch` varchar(100) NOT NULL,
  `status` enum('success','failed','unknown') NOT NULL DEFAULT 'unknown',
  `status_text` varchar(20) NOT NULL,
  `start_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `end_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `commit_message` text,
  `is_restarted` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `i_builder_build` (`builder`,`build_number`),
  KEY `i_revision` (`revision`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
