CREATE TABLE `adgroups_dynamic` (
  `pid` bigint(20) NOT NULL,
  `main_domain_id` int(10) unsigned DEFAULT NULL,
  `feed_id` bigint(20) unsigned DEFAULT NULL,
  `statusBlGenerated` enum('No','Processing','Yes') NOT NULL DEFAULT 'No',
  `relevance_match_categories` set('exact_mark','alternative_mark','competitor_mark','broader_mark','accessory_mark') NOT NULL DEFAULT '',
  `field_to_use_as_name` varchar(512) DEFAULT NULL,
  `field_to_use_as_body` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`pid`),
  KEY `i_main_domain_id` (`main_domain_id`),
  KEY `i_feed_id` (`feed_id`),
  CONSTRAINT `fk_adgroups_dynamic__feed_id` FOREIGN KEY (`feed_id`) REFERENCES `feeds` (`feed_id`),
  CONSTRAINT `fk_adgroups_dynamic__main_domain_id` FOREIGN KEY (`main_domain_id`) REFERENCES `domains` (`domain_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
