CREATE TABLE `banners` (
  `bid` bigint(20) NOT NULL,
  `type` enum('desktop','mobile') NOT NULL DEFAULT 'desktop',
  `pid` bigint(20) NOT NULL,
  `cid` int(10) unsigned NOT NULL,
  `title` text,
  `title_extension` text,
  `body` text,
  `href` text,
  `domain_id` int(10) unsigned DEFAULT NULL,
  `BannerID` bigint(20) NOT NULL,
  `statusShow` enum('Yes','No') DEFAULT 'Yes',
  `statusActive` enum('Yes','No') NOT NULL DEFAULT 'No',
  `statusModerate` enum('Yes','No','Sent','Sending','Ready','New') NOT NULL DEFAULT 'New',
  `geoflag` tinyint(8) DEFAULT '0',
  `statusArch` enum('Yes','No') DEFAULT 'No',
  `LastChange` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `statusBsSynced` enum('No','Yes','Sending') NOT NULL DEFAULT 'No',
  `domain` text,
  `phoneflag` enum('New','Sent','Sending','Ready','Yes','No') NOT NULL DEFAULT 'New',
  `reverse_domain` text,
  `statusPostModerate` enum('New','Yes','No','Ready','Sent','Rejected') NOT NULL DEFAULT 'No',
  `language` enum('Yes','No','ru','en','uk','de','be','kk','tr','uz','lv','et','lt','unknown','vie','es','pt','cs','pl') NOT NULL DEFAULT 'unknown',
  `vcard_id` int(10) DEFAULT NULL,
  `flags` text,
  `sitelinks_set_id` int(10) unsigned DEFAULT NULL,
  `statusSitelinksModerate` enum('New','Sent','Sending','Ready','Yes','No') NOT NULL DEFAULT 'New',
  `yacontextCategories` text,
  `opts` set('geoflag','no_display_href') NOT NULL,
  `banner_type` enum('text','dynamic','mobile_content','performance','image_ad','mcbanner','cpm_banner','cpc_video','cpm_outdoor','cpm_indoor','internal','cpm_audio','content_promotion','cpm_geo_pin','performance_main') NOT NULL DEFAULT 'text',
  PRIMARY KEY (`bid`),
  KEY `BannerID` (`BannerID`),
  KEY `LastChange` (`LastChange`),
  KEY `idx_banners_sbs` (`statusBsSynced`),
  KEY `statusModerate` (`statusModerate`),
  KEY `phoneflag` (`phoneflag`),
  KEY `i_vcard_id` (`vcard_id`),
  KEY `statusSitelinksModerate` (`statusSitelinksModerate`),
  KEY `i_sitelinks_set_id` (`sitelinks_set_id`),
  KEY `domain_id` (`domain_id`),
  KEY `cid` (`cid`,`type`),
  KEY `pid` (`pid`,`type`),
  KEY `i_reverse_domain` (`reverse_domain`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8
