CREATE TABLE `banners_performance` (
  `banner_creative_id` int(10) unsigned NOT NULL,
  `bid` bigint(20) NOT NULL DEFAULT '0',
  `pid` bigint(20) NOT NULL DEFAULT '0',
  `cid` int(10) unsigned NOT NULL,
  `creative_id` bigint(20) unsigned NOT NULL,
  `creative_variables` json DEFAULT NULL,
  `statusModerate` enum('Yes','No','Sent','Sending','Ready','New') NOT NULL DEFAULT 'New',
  `extracted_text` text,
  `show_title_and_body` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`banner_creative_id`),
  UNIQUE KEY `cid` (`cid`,`pid`,`bid`),
  KEY `bid` (`bid`),
  KEY `statusModerate` (`statusModerate`),
  KEY `creative_id` (`creative_id`),
  CONSTRAINT `banners_performance_ibfk_2` FOREIGN KEY (`creative_id`) REFERENCES `perf_creatives` (`creative_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
