CREATE TABLE `bids_base` (
  `bid_id` bigint(20) NOT NULL,
  `bid_type` enum('keyword','relevance_match_search','relevance_match','offer_retargeting') NOT NULL DEFAULT 'keyword',
  `pid` bigint(20) NOT NULL DEFAULT '0',
  `cid` int(10) unsigned NOT NULL,
  `price` decimal(8,2) NOT NULL DEFAULT '0.00',
  `price_context` decimal(8,2) NOT NULL DEFAULT '0.00',
  `LastChange` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `statusBsSynced` enum('No','Yes','Sending') NOT NULL DEFAULT 'No',
  `autobudgetPriority` tinyint(4) DEFAULT NULL,
  `opts` set('suspended','deleted','search_stop','net_stop') NOT NULL DEFAULT '',
  `relevance_match_categories` set('exact_mark','alternative_mark','competitor_mark','broader_mark','accessory_mark') NOT NULL DEFAULT '',
  PRIMARY KEY (`bid_id`),
  KEY `idx_bids_base_pid` (`pid`),
  KEY `idx_bids_base_cid` (`cid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
