CREATE TABLE `bids_dynamic` (
  `dyn_id` int(10) unsigned NOT NULL,
  `dyn_cond_id` int(10) unsigned NOT NULL,
  `pid` bigint(20) NOT NULL,
  `price` decimal(8,2) unsigned NOT NULL DEFAULT '0.00',
  `price_context` decimal(8,2) unsigned NOT NULL DEFAULT '0.00',
  `autobudgetPriority` tinyint(3) DEFAULT NULL,
  `statusBsSynced` enum('No','Sending','Yes') NOT NULL DEFAULT 'No',
  `opts` set('suspended') NOT NULL DEFAULT '',
  `from_tab` enum('all-products','condition','tree') NOT NULL DEFAULT 'condition',
  PRIMARY KEY (`dyn_id`),
  UNIQUE KEY `i_pid_dyn_cond_id` (`pid`,`dyn_cond_id`),
  KEY `dyn_cond_id` (`dyn_cond_id`),
  CONSTRAINT `fk_bids_dynamic__dyn_cond_id` FOREIGN KEY (`dyn_cond_id`) REFERENCES `dynamic_conditions` (`dyn_cond_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
