CREATE TABLE `camp_options` (
  `cid` int(10) unsigned NOT NULL DEFAULT '0',
  `FIO` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(255) NOT NULL DEFAULT '',
  `valid` tinyint(8) DEFAULT '2',
  `lastnews` bigint(20) NOT NULL DEFAULT '0',
  `sendNews` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `sendWarn` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `sendAccNews` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `stopTime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `contactinfo` text NOT NULL,
  `money_warning_value` tinyint(3) unsigned NOT NULL DEFAULT '20',
  `enabled_sms` enum('Yes','No') NOT NULL DEFAULT 'No',
  `banners_per_page` int(10) unsigned NOT NULL DEFAULT '0',
  `sms_time` varchar(50) NOT NULL DEFAULT '00:00:00:00',
  `sms_flags` set('active_orders_money_out_sms','active_orders_money_warning_sms','moderate_result_sms','notify_order_money_in_sms','notify_metrica_control_sms','camp_finished_sms','paused_by_day_budget_sms','notify_cashback_in_sms') NOT NULL DEFAULT '',
  `warnPlaceInterval` enum('15','30','60') NOT NULL DEFAULT '60',
  `statusMetricaControl` enum('Yes','No') NOT NULL DEFAULT 'No',
  `status_click_track` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `last_pay_time` datetime DEFAULT NULL,
  `auto_optimize_request` enum('Created','Sended','No') DEFAULT 'No',
  `mediaplan_status` enum('None','InProcess','Complete') DEFAULT 'None',
  `manual_autobudget_sum` double DEFAULT NULL,
  `camp_description` text,
  `statusPostModerate` enum('New','Yes','No','Accepted') NOT NULL DEFAULT 'New',
  `fairAuction` enum('No','Yes') NOT NULL DEFAULT 'No' COMMENT 'show campaign prices without timetarget-off campaigns',
  `offlineStatNotice` enum('Yes','No') DEFAULT 'Yes',
  `mw_id` int(10) unsigned DEFAULT NULL,
  `minus_words` text,
  `broad_match_flag` enum('Yes','No') NOT NULL DEFAULT 'No',
  `broad_match_limit` tinyint(8) NOT NULL DEFAULT '0',
  `broad_match_rate` enum('minimal','optimal','maximum','unused') NOT NULL DEFAULT 'unused',
  `broad_match_goal_id` bigint(20) unsigned DEFAULT '0',
  `statusContextStop` enum('Yes','No') NOT NULL DEFAULT 'No',
  `create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `strategy` enum('different_places','autobudget_avg_cpc_per_camp','autobudget_avg_cpc_per_filter','autobudget_avg_cpa_per_camp','autobudget_avg_cpa_per_filter') DEFAULT NULL,
  `day_budget_daily_change_count` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `day_budget_stop_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `day_budget_notification_status` enum('Ready','Sent') DEFAULT 'Ready',
  `day_budget_last_change` datetime DEFAULT NULL,
  `email_notifications` set('paused_by_day_budget','feed_status_change') DEFAULT 'paused_by_day_budget',
  `competitors_domains` text,
  `device_targeting` varchar(100) NOT NULL DEFAULT '',
  `mobile_multiplier_pct` smallint(6) DEFAULT NULL,
  `is_related_keywords_enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `content_lang` varchar(2) DEFAULT NULL,
  `meaningful_goals` json DEFAULT NULL,
  `allowed_page_ids` json DEFAULT NULL,
  `disallowed_page_ids` json DEFAULT NULL,
  `allowed_domains` json DEFAULT NULL,
  `allowed_ssp` json DEFAULT NULL,
  `mobile_app_goal` enum('clicks','installs','in_app_actions','reattribution') NOT NULL DEFAULT 'clicks',
  `brand_survey_id` varchar(100) DEFAULT NULL,
  `is_search_lift_enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_cpm_global_ab_segment` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `impression_standard_time` smallint(6) DEFAULT NULL,
  `eshows_banner_rate` decimal(5,3) DEFAULT NULL,
  `eshows_video_rate` decimal(5,3) DEFAULT NULL,
  `eshows_video_type` set('long_clicks','completes') DEFAULT NULL,
  `placement_types` set('search_page','adv_gallery') NOT NULL DEFAULT '',
  `href_params` varchar(2048) DEFAULT NULL,
  PRIMARY KEY (`cid`),
  KEY `create_time` (`create_time`),
  KEY `mw_id` (`mw_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
