CREATE TABLE `campaigns` (
  `cid` int(10) unsigned NOT NULL,
  `ClientID` int(10) unsigned NOT NULL DEFAULT '0',
  `uid` bigint(20) unsigned NOT NULL,
  `ManagerUID` bigint(20) DEFAULT NULL,
  `AgencyUID` bigint(20) DEFAULT NULL,
  `name` text,
  `LastChange` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `start_time` date NOT NULL DEFAULT '0000-00-00',
  `OrderID` bigint(20) NOT NULL DEFAULT '0',
  `AgencyID` int(10) NOT NULL DEFAULT '0',
  `currency` enum('RUB','UAH','KZT','USD','EUR','YND_FIXED','CHF','TRY','BYN','GBP') NOT NULL,
  `sum_to_pay` decimal(16,6) NOT NULL,
  `sum` decimal(16,6) NOT NULL,
  `sum_spent` decimal(16,6) NOT NULL,
  `sum_last` decimal(16,6) NOT NULL,
  `sum_spent_units` bigint(20) DEFAULT NULL,
  `sum_units` bigint(20) DEFAULT NULL,
  `sum_balance` decimal(16,6) NOT NULL DEFAULT '0.000000',
  `wallet_cid` int(10) unsigned NOT NULL DEFAULT '0',
  `statusModerate` enum('Yes','No','Sent','Ready','New','Mediaplan') DEFAULT 'New',
  `statusShow` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `statusActive` enum('Yes','No') NOT NULL DEFAULT 'No' COMMENT 'Real order status on BS frontend',
  `shows` bigint(20) DEFAULT NULL,
  `clicks` int(10) DEFAULT NULL,
  `statusEmpty` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `statusMail` int(10) DEFAULT '0',
  `archived` enum('Yes','No') NOT NULL DEFAULT 'No',
  `balance_tid` bigint(20) NOT NULL DEFAULT '0',
  `autobudget` enum('Yes','No') NOT NULL DEFAULT 'No',
  `platform` enum('search','context','both') DEFAULT NULL,
  `strategy_id` int(10) unsigned NOT NULL DEFAULT '0',
  `strategy_name` enum('default','min_price','no_premium','autobudget','autobudget_media','autobudget_week_bundle','autobudget_avg_click','autobudget_avg_cpa','autobudget_avg_cpa_per_camp','autobudget_avg_cpa_per_filter','autobudget_avg_cpc_per_camp','autobudget_avg_cpc_per_filter','autobudget_avg_cpi','autobudget_roi','cpm_default','autobudget_max_reach','autobudget_max_impressions','autobudget_max_reach_custom_period','autobudget_max_impressions_custom_period','period_fix_bid','autobudget_avg_cpv','autobudget_avg_cpv_custom_period','autobudget_crr') DEFAULT NULL,
  `strategy_data` json DEFAULT NULL,
  `autobudget_date` date NOT NULL DEFAULT '0000-00-00',
  `statusBsSynced` enum('No','Yes','Sending') NOT NULL DEFAULT 'No',
  `statusNoPay` enum('No','Yes') NOT NULL DEFAULT 'No',
  `geo` text,
  `DontShow` text,
  `autoOptimization` enum('No','Yes') NOT NULL DEFAULT 'No',
  `dontShowCatalog` enum('No','Yes') NOT NULL DEFAULT 'No',
  `autobudgetForecastDate` datetime DEFAULT NULL,
  `autobudgetForecast` double DEFAULT NULL,
  `statusAutobudgetForecast` enum('New','Valid','Wrong') NOT NULL DEFAULT 'New',
  `timeTarget` text,
  `timezone_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `lastShowTime` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `statusBsArchived` enum('Yes','No') NOT NULL DEFAULT 'No',
  `statusOpenStat` enum('No','Yes') NOT NULL DEFAULT 'No',
  `disabledIps` text,
  `statusBehavior` enum('Yes','No') NOT NULL DEFAULT 'Yes',
  `type` enum('text','mcb','geo','wallet','mobile_content','performance','dynamic','mcbanner','cpm_banner','cpm_deals','cpm_yndx_frontpage','billing_aggregate','internal_distrib','internal_free','internal_autobudget','content_promotion','cpm_price') NOT NULL DEFAULT 'text',
  `ProductID` int(10) DEFAULT NULL,
  `rf` smallint(5) unsigned NOT NULL DEFAULT '0',
  `rfReset` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `ContextLimit` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '0 - auto, 254 - shows disabled, 255 - limiting disabled',
  `ContextPriceCoef` tinyint(3) unsigned NOT NULL DEFAULT '100',
  `finish_time` date NOT NULL DEFAULT '0000-00-00',
  `day_budget` decimal(16,2) unsigned NOT NULL DEFAULT '0.00',
  `day_budget_show_mode` enum('default','stretched') NOT NULL DEFAULT 'default',
  `paid_by_certificate` enum('Yes','No') NOT NULL DEFAULT 'No',
  `currencyConverted` enum('Yes','No') NOT NULL DEFAULT 'No',
  `copiedFrom` int(10) unsigned NOT NULL DEFAULT '0',
  `opts` set('no_title_substitute','enable_cpc_hold','no_extended_geotargeting','hide_permalink_info','is_virtual','has_turbo_smarts','is_auto_video_allowed','is_alone_trafaret_allowed','is_touch','has_turbo_app','require_filtration_by_dont_show_domains','is_simplified_strategy_view_enabled','is_universal','is_order_phrase_length_precedence_enabled','meaningful_goals_values_from_metrika','is_new_ios_version_enabled','is_skadnetwork_enabled','is_allowed_on_adult_content','is_brand_lift_hidden','s2s_tracking_enabled','recommendations_management_enabled','price_recommendations_management_enabled','use_current_region','use_regular_region','is_ww_managed_order') NOT NULL DEFAULT '',
  `disabled_ssp` text,
  `disabled_video_placements` json DEFAULT NULL,
  `attribution_model` enum('last_click','first_click','last_significant_click','last_yandex_direct_click','first_click_cross_device','last_significant_click_cross_device','last_yandex_direct_click_cross_device') DEFAULT NULL,
  `ab_segment_stat_ret_cond_id` int(10) unsigned DEFAULT NULL,
  `ab_segment_ret_cond_id` int(10) unsigned DEFAULT NULL,
  `b_segment_ret_cond_id` int(10) unsigned DEFAULT NULL,
  `brandsafety_ret_cond_id` int(10) unsigned DEFAULT NULL,
  `source` enum('direct','uac','uslugi','eda','geo','dc','api','xls','zen','widget') NOT NULL DEFAULT 'direct',
  `metatype` enum('default','ecom') NOT NULL DEFAULT 'default',
  `cashback` decimal(16,6) DEFAULT NULL,
  `total_cashback` decimal(16,6) DEFAULT NULL,
  PRIMARY KEY (`cid`),
  KEY `i_uid` (`uid`),
  KEY `OrderID` (`OrderID`),
  KEY `ManagerUID` (`ManagerUID`),
  KEY `AgencyUID` (`AgencyUID`),
  KEY `idx_campaigns_sbs` (`statusBsSynced`),
  KEY `statusModerate` (`statusModerate`),
  KEY `LastChange` (`LastChange`),
  KEY `ClientID` (`ClientID`),
  KEY `wallet_cid` (`wallet_cid`),
  KEY `ab_segment_stat_ret_cond_id` (`ab_segment_stat_ret_cond_id`),
  KEY `ab_segment_ret_cond_id` (`ab_segment_ret_cond_id`),
  KEY `brandsafety_ret_cond_id` (`brandsafety_ret_cond_id`),
  KEY `strategy_id` (`strategy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
