CREATE TABLE `client_phones` (
  `client_phone_id` int(10) unsigned NOT NULL,
  `ClientID` int(10) unsigned NOT NULL,
  `phone_type` enum('manual','sprav','telephony') NOT NULL DEFAULT 'manual',
  `phone` varchar(25) NOT NULL,
  `comment` varchar(255) NOT NULL DEFAULT '',
  `permalink_id` bigint(20) NOT NULL DEFAULT '0',
  `counter_id` bigint(20) NOT NULL DEFAULT '0',
  `telephony_service_id` varchar(36) NOT NULL DEFAULT '',
  `telephony_phone` varchar(25) DEFAULT NULL,
  `last_show_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `is_deleted` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `uniq_sprav_phone` varchar(50) GENERATED ALWAYS AS (if((`phone_type` = 'sprav'),concat(`permalink_id`,'|',`phone`),NULL)) VIRTUAL,
  PRIMARY KEY (`client_phone_id`),
  UNIQUE KEY `i_uniq_sprav_phone` (`ClientID`,`uniq_sprav_phone`),
  KEY `i_ClientID` (`ClientID`),
  KEY `i_permalink_id` (`permalink_id`),
  KEY `i_telephony_service_id` (`telephony_service_id`),
  KEY `i_phone_type` (`phone_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
