CREATE TABLE `clients` (
  `ClientID` int(10) unsigned NOT NULL DEFAULT '0',
  `role` enum('empty','client','agency','manager','super','superreader','support','placer','media','internal_ad_admin','internal_ad_manager','internal_ad_superreader','limited_support') NOT NULL DEFAULT 'empty',
  `subrole` enum('superteamleader','teamleader','superplacer','supermedia') DEFAULT NULL,
  `chief_uid` bigint(20) DEFAULT NULL,
  `agency_client_id` int(11) DEFAULT NULL,
  `agency_uid` bigint(20) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `work_currency` enum('RUB','UAH','KZT','USD','EUR','YND_FIXED','CHF','TRY','BYN','GBP') DEFAULT NULL,
  `create_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `deleted_reps` mediumtext,
  `agency_url` varchar(255) DEFAULT NULL COMMENT 'from balance',
  `agency_status` enum('SA','AA','HY','WC','NR','ABU') DEFAULT NULL,
  `primary_manager_uid` bigint(20) DEFAULT NULL,
  `primary_manager_set_by_idm` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `primary_bayan_manager_uid` bigint(20) DEFAULT NULL,
  `primary_geo_manager_uid` bigint(20) DEFAULT NULL,
  `allow_create_scamp_by_subclient` enum('No','Yes') NOT NULL DEFAULT 'No',
  `can_use_day_budget` enum('Yes','No') NOT NULL DEFAULT 'No',
  `country_region_id` int(10) unsigned NOT NULL DEFAULT '0',
  `is_favicon_blocked` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `agency_allow_wallet` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `perms` set('super_subclient','xls_import','mass_advq','money_transfer','internal_ad_product') NOT NULL DEFAULT '',
  `connect_org_id` int(10) unsigned DEFAULT NULL,
  `report_name` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`ClientID`),
  KEY `chief_uid` (`chief_uid`),
  KEY `agency_client_id` (`agency_client_id`),
  KEY `agency_uid` (`agency_uid`),
  KEY `primary_manager_uid` (`primary_manager_uid`),
  KEY `primary_bayan_manager_uid` (`primary_bayan_manager_uid`),
  KEY `role` (`role`),
  KEY `connect_org_id` (`connect_org_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
