CREATE TABLE `clients_options` (
  `ClientID` int(10) unsigned NOT NULL,
  `balance_tid` bigint(20) unsigned NOT NULL,
  `market_business_id` bigint(20) DEFAULT NULL,
  `overdraft_lim` decimal(10,2) NOT NULL,
  `auto_overdraft_lim` decimal(10,2) NOT NULL DEFAULT '0.00',
  `debt` decimal(10,2) NOT NULL,
  `cashback_bonus` decimal(10,2) DEFAULT NULL,
  `cashback_awaiting_bonus` decimal(10,2) DEFAULT NULL,
  `nextPayDate` date NOT NULL,
  `statusBalanceBanned` enum('Yes','No') DEFAULT 'No',
  `warned_nextPayDate` date DEFAULT NULL,
  `warned_interval` tinyint(4) DEFAULT NULL,
  `discount` decimal(4,2) DEFAULT NULL,
  `budget` decimal(24,2) DEFAULT NULL,
  `border_next` decimal(10,2) DEFAULT NULL,
  `discount_next` decimal(4,2) DEFAULT NULL,
  `border_prev` decimal(10,2) DEFAULT NULL,
  `hide_market_rating` tinyint(1) NOT NULL DEFAULT '0',
  `use_adgroups` tinyint(4) NOT NULL DEFAULT '0',
  `non_resident` tinyint(1) DEFAULT '0',
  `budget_currency` enum('RUB','UAH','KZT','USD','EUR','YND_FIXED','CHF','TRY','BYN','GBP') DEFAULT NULL,
  `client_flags` set('no_text_autocorrection','no_display_hrefs','not_agreed_on_creatives_autogeneration','can_copy_ctr','not_convert_to_currency','auto_video','suspend_video','feature_access_auto_video','create_without_wallet','feature_context_relevance_match_allowed','feature_context_relevance_match_interface_only','cant_unblock','feature_payment_before_moderation','is_touch','as_soon_as_possible','auto_overdraft_notified','is_pro_strategy_view_enabled','is_conversion_multipliers_popup_disabled','videohints_enabled') DEFAULT NULL,
  `subregion_id` int(10) unsigned DEFAULT NULL,
  `is_business_unit` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_brand` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_ya_agency_client` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `common_metrika_counters` varchar(100) DEFAULT NULL,
  `is_using_quasi_currency` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `gdpr_agreement_accepted_time` datetime DEFAULT NULL,
  `can_manage_price_packages` tinyint(1) NOT NULL DEFAULT '0',
  `can_approve_price_packages` tinyint(1) NOT NULL DEFAULT '0',
  `camp_copy_ela` varchar(32) DEFAULT NULL,
  `default_disallowed_page_ids` json DEFAULT NULL,
  `default_allowed_domains` json DEFAULT NULL,
  `social_advertising` tinyint(1) NOT NULL DEFAULT '0',
  `tin` varchar(12) DEFAULT NULL,
  `alternative_tin` varchar(50) DEFAULT NULL,
  `tin_type` enum('physical','legal','individual','foreign_physical','foreign_legal') DEFAULT NULL,
  `phone_verification_status` enum('need_verification','verification_in_progress','verified') NOT NULL DEFAULT 'verified',
  `last_change_phone_verification_status` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `experiment_id` int(10) unsigned DEFAULT NULL,
  `segment_id` int(10) unsigned DEFAULT NULL,
  `counterparty_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`ClientID`),
  KEY `i_market_business_id` (`market_business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
