CREATE TABLE `content_promotion` (
  `id` bigint(20) NOT NULL,
  `ClientID` int(10) unsigned NOT NULL,
  `type` enum('video','collection','service','eda') NOT NULL DEFAULT 'video',
  `url` text NOT NULL,
  `external_id` varchar(255) NOT NULL,
  `preview_url` text,
  `is_inaccessible` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `metadata` json DEFAULT NULL,
  `metadata_hash` bigint(20) unsigned DEFAULT NULL,
  `metadata_create_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `metadata_modify_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `metadata_refresh_time` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `i_ClientID_external_id_type` (`ClientID`,`external_id`,`type`),
  KEY `i_metadata_refresh_time_type` (`metadata_refresh_time`,`type`),
  KEY `i_external_id` (`external_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8
